/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.screens;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.whereaboutsboard.WhereaboutsboardGroupSelectData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 行先板のグループリストの一覧を処理するクラスです。 <br />
 * 
 */
public class WhereaboutsboardGroupScreen extends ALVelocityScreen {
  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
      .getLogger(WhereaboutsboardGroupScreen.class.getName());

  /**
   * @see org.apache.turbine.modules.screens.RawScreen#doOutput(org.apache.turbine.util.RunData)
   */
  @Override
  // グループリスト選択後のAjax画面読み込み
  protected void doOutput(RunData rundata, Context context) throws Exception {

    VelocityPortlet portlet = ALEipUtils.getPortlet(rundata, context); // 結果を返すため自分のポートレットを取得

    try {

      WhereaboutsboardGroupSelectData listData = new WhereaboutsboardGroupSelectData();
     
      // PSMLからパラメータをロードする
      // 最大表示件数（最大化時）
      listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig()
          .getInitParameter("p1a-rows")));
      listData.doViewList(this, rundata, context);// DBからのオブジェクトをコンテキストに入れるだけの処理
      String layout_template = "portlets/html/ja/ajax-whereaboutsboardgroup.vm";// 使用するテンプレート選択
      setTemplate(rundata, context, layout_template);// 使用するテンプレートを指定

    } catch (Exception ex) {
      logger.error("[WhereaboutsboardGroupScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }
}
