/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.util;


// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;

/**
 * Command Line Test Validation routines.
 *
 * @author <a href="mailto:ben.woodward@bbc.co.uk">Ben Woodward</a>
 * @version $Id: TestValidation.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestValidation extends JetspeedTestCase
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestValidation( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestValidation.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing Validation");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestValidation.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testAlphaNumeric() throws Exception
    {
        String goodString = "The quick brown fox jumped over the lazy dog 0123456789";
        String badString = "><$$!&.*";

        assertTrue(ValidationHelper.isAlphaNumeric(goodString, false));        
        assertTrue(!ValidationHelper.isAlphaNumeric(badString, false));        
    }
    
    public void testLooseAlphaNumeric() throws Exception
    {
        //String goodString = "The quick brown fox jumped over the lazy dog 0123456789 .";
        //String goodString = "www.www.www-/()+";
        //String badString = "><$$!&*.";
        
        String goodString[] = {"a","a.a","aaa.aaa","a-a","aaa-aaa", "(aaa) aaa", "+aa-aaa.aa", "555-4545", "555,4545"};
        String badString[] = {"><$$!&*."};   
        
        
        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isLooseAlphaNumeric(goodString[ia], false));
            System.out.println(goodString[ia]+" is Good: "+ValidationHelper.isLooseAlphaNumeric(goodString[ia], false));
        }
        
        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isLooseAlphaNumeric(badString[ib], false));
            System.out.println(badString[ib]+" is Bad: "+!ValidationHelper.isLooseAlphaNumeric(badString[ib], false));
        }      
    }
    
    public void testDecimal() throws Exception
    {
        
        String goodString[] = {"1","1.1","11.1","1.11","11.11"};
        String badString[] = {"a","1.a","1-a","1..1","1.1.1"};      
        
        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isDecimal(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isDecimal(badString[ib], false));
        }
    }
    
    public void testInteger() throws Exception
    {
        
        String goodString[] = {"1","11","111"};
        String badString[] = {"a","1.1","1.a","1-a","1..1","1.1.1"};      

        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isInteger(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isInteger(badString[ib], false));
        }
    }
    
    
    public void testEmailAddress() throws Exception
    {

        String goodString[] = {"a@b.c","a.b@c.d","aa@b.c","aaa@b.c"};
        String badString[] = {"*@b.c","a","a@","@a",".@a","a@b.","a@b","a@@b.c","a@b@c.d","aaa@b^.c"};      

        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isEmailAddress(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isEmailAddress(badString[ib], false));
        }
    }
    
    public void testURL() throws Exception
    {
        String goodString = "http://www.apache.org";
        String badString = "me.";
        
        assertTrue(ValidationHelper.isURL(goodString, false));        
        assertTrue(!ValidationHelper.isURL(badString, false));        
    }


    /*
    Configuration object to run Turbine outside a servlet container
    ( uses turbine.properties )
    private static TurbineConfig config = null;
    
    static
    {
    try
    {
    config = new TurbineConfig( "./bin", "/WEB-INF/conf/TurbineResources.properties");
    config.init();
    }
    catch (Exception e)
    {
    //fail(StringUtils.stackTrace(e));
    System.out.println(StringUtils.stackTrace(e));
    }
    }
     */
}



