/*
 * Copyright 2000-2001,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jetspeed.services.profiler;

import java.io.File;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Jetspeed imports
import org.apache.jetspeed.test.JetspeedTestCase;
import org.apache.jetspeed.om.profile.*;
import org.apache.jetspeed.om.profile.psml.*;

import org.apache.jetspeed.services.Profiler;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

/**
 * TestProfilerService
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestProfilerService.java,v 1.1 2004/04/07 22:02:42 jford Exp $
 */

public class TestProfilerService extends JetspeedTestCase {

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestProfilerService( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestProfilerService.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing categories of Profiler Service");
     }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestProfilerService.class );
    }

    /**
     * Tests categories
     * @throws Exception
     */
    public void testCreateProfile() throws Exception
    {
        try
        {
            ProfileLocator locator = Profiler.createLocator();
            locator.setGroupByName("apache");
            locator.setName("create-test");

            Portlets portlets = new PsmlPortlets();
            Control control = new PsmlControl();
            Controller controller = new PsmlController();
            control.setName("BoxControl");
            controller.setName("GridPortletController");
            portlets.setControl(control);
            portlets.setController(controller);
            Profile profile = Profiler.createProfile(locator, portlets);
            PSMLDocument doc = profile.getDocument();

            System.out.println("doc = " + doc.getName());

            // this only works with the default configuration (Castor/Filebased)
            File file = new File(doc.getName());
            assertTrue(file.exists());
            //file.delete();
        }
        catch (Exception e)
        {
            String errmsg = "Error in Profiler Service: " + e.toString();
            e.printStackTrace();
            assertNotNull(errmsg, null);
        }
    }

    /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;

    /*
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }
}

