/*
 * Copyright 2000-2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jetspeed.services.customlocalization;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;

// Java APIs
import java.util.Locale;

import org.apache.jetspeed.services.customlocalization.CustomLocalization;
import org.apache.jetspeed.test.HeadlessBaseTest;

/**
 * Command Line Test Localization routines.
 *
 * @author <a href="mailto:morciuch@">Mark Orciuch</a>
 * @version $Id: TestLocalization.java,v 1.1 2004/04/07 22:02:43 jford Exp $
 */

public class TestLocalization extends HeadlessBaseTest
{
    /**
     * Defines the testcase name for JUnit.
     * 
     * @param name   the testcase's name.
     */
    public TestLocalization(String name)
    {
        super(name);
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main(new String[] {TestLocalization.class.getName()});
    }

    /**
     */
    public void setup()
    {
        System.out.println("Setup: Testing Localization");
    }

    /**
     * 
     * @return 
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestLocalization.class);
    }


    ///////////////////////////////////////////////////////////////////////////

    public void testGoodTranslation() throws Exception
    {
        Locale locale = null;
        String test = null;

        // Test English translation
        locale = new Locale("en", "US");
        test = CustomLocalization.getString(null, locale, "LOGIN_USERNAME");
        System.out.println("Locale [en-US]: LOGIN_USER translation = " + test);

        assertTrue(test.equals("Username:"));

        // Test Polish translation
        locale = new Locale("pl", "");
        test = CustomLocalization.getString(null, locale, "LOGIN_TITLE");
        System.out.println("Locale [pl]: LOGIN_TITLE translation = " + test);

        assertTrue(test.equals("Logowanie"));
    
        // Test case when only english translation exists
        locale = new Locale("my", "");
        test = CustomLocalization.getString(null, locale, "_TEST_");
        System.out.println("Locale [my]: _TEST_ = " + test);

        assertTrue(test.equals("Do not translate"));

    }

}



