/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.cms;



// Java core classes
import java.util.*;

// Tubine
import org.apache.turbine.services.*;
//import org.apache.turbine.services.resources.*;

// Jetspeed
import org.apache.jetspeed.services.cms.manager.CmsFactory;
import org.apache.jetspeed.services.cms.manager.CmsManager;
import org.apache.jetspeed.services.cms.JetspeedCMSException;


/**
 * Default CMS service.
 * This class is an implementation of {@link CmsService}.
 *
 * @author <a href="mailto:christophe.lombart@skynet.be">Christophe Lombart</a>
 *
 */
public class DefaultCmsService
    extends BaseService
    implements CmsService
{

    /**
     *  List of all Cms Manager used by the service.
     *  TO DO : replace by the pool service (?)
     */
     private Hashtable cmsRepositories = new Hashtable();

    /**
     * Default namespace value.
     */
    private final static String DEFAULT_NAMESPACE_VALUE = "jetspeed";

    /**
     * Initialize the CMS Service.
     * @exception InitializationException error during initialization
     */
	public void init() throws InitializationException
	{
        // init the default CmsManager
        try
        {
	        this.getCmsManager();
		}
		catch( JetspeedCMSException e)
		{
			throw new InitializationException("CMSService: Unable to retrieve default CMSManager");
		}

        setInit(true);
	}

    public CmsManager getCmsManager() throws JetspeedCMSException
    {
		return this.getCmsManager(DEFAULT_NAMESPACE_VALUE);
	}

    public CmsManager getCmsManager(String nameSpace) throws JetspeedCMSException
    {
		CmsManager cms = null;

		try
		{
			cms = (CmsManager) cmsRepositories.get(nameSpace);

			if (cms == null)
			{
				cms = CmsFactory.getCmsManagerInstance(nameSpace);
				cmsRepositories.put(nameSpace, cms);
			}
		}
		catch (Exception e)
		{
			throw new JetspeedCMSException("System Error : impossible to access to the content repository");
		}

		return cms;
	}
}
