/*
 * "CUnit for Mr.Ando" is CppUnit-x based C langage testing framework
 * for Mr.Ando. It provide the C source code for unit testing. 
 * Copyright (C) 2004 Toshikazu Ando.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <testRunner.h>
#include "plus.h"
#include "sequence.h"

static unsigned int testSequence(void);


/* test data */
static unsigned int inPlus_data1;
static unsigned int inPlus_data2;
static unsigned int outPlus_ans;
static unsigned int returnPlus;

/** Main function. */
int main(void) {
    return (int) testRunner(testSequence);
}

static unsigned int testSequence(void) {
    unsigned int err;
    unsigned int ans;
    unsigned int data1;
    unsigned int data2;
    
    /////////////////////////////////////////////////
    // Normal test
    data1 = 0; // 0-0xffffffffu
    data2 = 0xffffffffu; // 0-0xffffffffu
    inPlus_data1 = 0xffffffffu; // pollute
    inPlus_data2 = 0xffffffffu; // pollute
    outPlus_ans = 99; // 0-99
    returnPlus = 0; // 0(Normal),1-0xffffffffu(Abnormal)
    
    err = sequence(data1,data2,&ans); // run!
    
    TEST_ASSERT_EQUALS(err,(int)returnPlus);
    TEST_ASSERT_EQUALS(data1,(int)inPlus_data1);
    TEST_ASSERT_EQUALS(data2,(int)inPlus_data2);
    TEST_ASSERT_EQUALS(ans,(int)outPlus_ans);
    
    /////////////////////////////////////////////////
    // Abnormal test
    data1 = 0; // 0-0xffffffffu
    data2 = 0xffffffffu; // 0-0xffffffffu
    inPlus_data1 = 0xffffffffu; // pollute
    inPlus_data2 = 0xffffffffu; // pollute
    outPlus_ans = 1; // 0-99
    returnPlus = 1; // 0(Normal),1-0xffffffffu(Abnormal)
    
    err = sequence(data1,data2,&ans); // run!
    
    TEST_ASSERT_EQUALS(err,(int)returnPlus);
    TEST_ASSERT_EQUALS(data1,(int)inPlus_data1);
    TEST_ASSERT_EQUALS(data2,(int)inPlus_data2);

    return 0;
}

/** driver */
unsigned int plus(
    unsigned int data1,
    unsigned int data2,
    unsigned int *ans) {
    inPlus_data1 = data1;
    inPlus_data2 = data2;
    *ans = outPlus_ans;
    return returnPlus;
}
