/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "ViewOptionWidget.h"
#include "View.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QGridLayout>

ViewOptionWidget::ViewOptionWidget(QWidget *parent)
: OptionWidget(parent), view(0)
{
	setWindowTitle(tr("View"));
}

ViewOptionWidget::~ViewOptionWidget()
{
	delete view;
}

void ViewOptionWidget::construct()
{
	setWhatsThis("set view");

	mapCheckBox = new QCheckBox;
	mapCheckBox->setText(tr("&Map"));
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	rotationXDoubleSpinBox = new QDoubleSpinBox;
	rotationXDoubleSpinBox->setMaximum(180);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			rotationXDoubleSpinBox, SLOT(setDisabled(bool)));
	connect(rotationXDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	rotationXLabel = new QLabel;
	rotationXLabel->setText(tr("&X axis:"));
	rotationXLabel->setBuddy(rotationXDoubleSpinBox);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			rotationXLabel, SLOT(setDisabled(bool)));

	rotationZDoubleSpinBox = new QDoubleSpinBox;
	rotationZDoubleSpinBox->setMaximum(360);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			rotationZDoubleSpinBox, SLOT(setDisabled(bool)));
	connect(rotationZDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	rotationZLabel = new QLabel;
	rotationZLabel->setText(tr("&Z axis:"));
	rotationZLabel->setBuddy(rotationZDoubleSpinBox);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			rotationZLabel, SLOT(setDisabled(bool)));

	scalingDoubleSpinBox = new QDoubleSpinBox;
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			scalingDoubleSpinBox, SLOT(setDisabled(bool)));
	connect(scalingDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	scalingLabel = new QLabel;
	scalingLabel->setText(tr("&Scale:"));
	scalingLabel->setBuddy(scalingDoubleSpinBox);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			scalingLabel, SLOT(setDisabled(bool)));

	scalingZDoubleSpinBox = new QDoubleSpinBox;
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			scalingZDoubleSpinBox, SLOT(setDisabled(bool)));
	connect(scalingZDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	scalingZLabel = new QLabel;
	scalingZLabel->setText(tr("Sca&le of z axis:"));
	scalingZLabel->setBuddy(scalingZDoubleSpinBox);
	connect(mapCheckBox, SIGNAL(toggled(bool)),
			scalingZLabel, SLOT(setDisabled(bool)));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(mapCheckBox, 0, 0);
	mainLayout->addWidget(rotationXLabel, 1, 0);
	mainLayout->addWidget(rotationXDoubleSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(rotationZLabel, 2, 0);
	mainLayout->addWidget(rotationZDoubleSpinBox, 2, 1);
	mainLayout->addWidget(scalingLabel, 3, 0);
	mainLayout->addWidget(scalingDoubleSpinBox, 3, 1);
	mainLayout->addWidget(scalingZLabel, 4, 0);
	mainLayout->addWidget(scalingZDoubleSpinBox, 4, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 5, 0);

	setLayout(mainLayout);
}

void ViewOptionWidget::init()
{
	delete view;
	view = new View;
	setWidget();
}

void ViewOptionWidget::apply()
{
	view->setMap(mapCheckBox->isChecked());
	view->setRotationX(rotationXDoubleSpinBox->value());
	view->setRotationZ(rotationZDoubleSpinBox->value());
	view->setScaling(scalingDoubleSpinBox->value());
	view->setScalingZ(scalingZDoubleSpinBox->value());
	emit executed(view->command());
}

void ViewOptionWidget::setWidget()
{
	bool isMap = view->isMap();
	mapCheckBox->setChecked(isMap);
	rotationXDoubleSpinBox->setValue(view->rotationX());
	rotationXDoubleSpinBox->setEnabled(!isMap);
	rotationXLabel->setEnabled(!isMap);
	rotationZDoubleSpinBox->setValue(view->rotationZ());
	rotationZDoubleSpinBox->setEnabled(!isMap);
	rotationZLabel->setEnabled(!isMap);
	scalingDoubleSpinBox->setValue(view->scaling());
	scalingDoubleSpinBox->setEnabled(!isMap);
	scalingLabel->setEnabled(!isMap);
	scalingZDoubleSpinBox->setValue(view->scalingZ());
	scalingZDoubleSpinBox->setEnabled(!isMap);
	scalingZLabel->setEnabled(!isMap);
}
