/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef TRANSLATOR_INCLUDED
#define TRANSLATOR_INCLUDED

#include <QtCore/QCoreApplication>
#include <QtCore/QLocale>
#include <QtCore/QTranslator>

#include <cstring> // strcmp()

class Translator : public QTranslator
{ 
	Q_OBJECT

	public:
		Translator(QObject *parent = 0) : QTranslator(parent) { }

		QString translate(const char *context, const char *sourceText, 
				const char *comment = 0) const
		{
			if (!std::strcmp(context, "QMenuBar")
					&& !std::strcmp(sourceText, "About %1")) {
				return QCoreApplication::translate("MainWindow", "About %1")
					.arg(QCoreApplication::applicationName());
			}
			return QTranslator::translate(context, sourceText, comment);
		}
};

#endif // TRANSLATOR_INCLUDED
