/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "Mapping.h"

const char * const Mapping::COORDINATE[] = {
	QT_TRANSLATE_NOOP("Mapping", "cartesian"),
	QT_TRANSLATE_NOOP("Mapping", "spherical"),
	QT_TRANSLATE_NOOP("Mapping", "cylindrical"),
	""
};

Mapping::Mapping() : coordinate_(0)
{
}

void Mapping::setCoordinate(int coord)
{
	coordinate_ = coord;
}

int Mapping::coordinate() const
{
	return coordinate_;
}

QString Mapping::command() const
{
	return "set mapping " + QString(COORDINATE[coordinate_]);
}
