/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007, 2008 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLOT_OPTION_WIDGET_INCLUDED
#define PLOT_OPTION_WIDGET_INCLUDED

#include <QtGui/QWidget>

class PlotOptionWidget : public QWidget
{
	Q_OBJECT

	public:
		explicit PlotOptionWidget(QWidget *parent = 0) : QWidget(parent) { }
		virtual ~PlotOptionWidget() { }

		//! ウィジェットの状態をメンバ変数のオブジェクトに反映させる
		virtual void apply() = 0;
		//! ウィジェットの状態の変化を破棄する
		void discard() { setWidget(); }

	protected:
		//! メンバ変数のオブジェクトの状態からウィジェットの状態を設定する
		virtual void setWidget() = 0;

	private:
		// don't implement these
		PlotOptionWidget(const PlotOptionWidget &);
		PlotOptionWidget &operator=(const PlotOptionWidget &);
};
#endif // PLOT_OPTION_WIDGET_INCLUDED
