/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef M_AXIS_TICS_INCLUDED
#define M_AXIS_TICS_INCLUDED

#include "Option.h"

#include <QtCore/QList>
#include <QtCore/QString>

//! set m{axis}tics コマンド
class MAxisTics : public Option
{
	public:
		MAxisTics();

		void setDefault(int axis, bool flag);
		bool isDefault(int axis) const;

		void setFrequency(int axis, const QString &freq);
		const QString &frequency(int axis) const;

		QString command() const;

		//! 軸
		static const QString AXIS[];
	private:
		QList<bool> defaultList;
		QList<QString> freqList;
};
#endif // M_AXIS_TICS_INCLUDED
