/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
/*! \mainpage
 * 
 * \section gnuplot cueplot -> gnuplot
 *
 * Cueplot は Process クラス内で gnuplot を呼び出しています。
 * gnuplot のコマンドを実行する場合にはそのコマンドを引数として
 * Process::execute() 関数を呼びます。
 *
 * \section dir ディレクトリ構成
 *
 * \subsection command command ディレクトリ
 *
 * command ディレクトリ内のファイルでは Command クラスと CommandOption クラス
 * 及びその派生クラスが定義されています。 Command クラスの派生クラスの名前は
 * そのクラスが表すコマンド名に対応します。例えば、 Plot クラスは 
 * \c plot クラスに対応しています。 CommandOption クラスの派生クラスの名前には
 * 接頭語として対応するコマンド名が付いています。例えば、 FitRange クラスは 
 * \c fit コマンドのオプションを扱うクラスです。
 *
 * \subsection opt opt ディレクトリ
 *
 * opt ディレクトリ内のファイルで定義されているクラスは \c set コマンドの
 * オプションを扱います。クラス名は \c set コマンドのオプションから
 * 付けられており、例えば、 Dummy クラスは <code>set dummy</code> コマンドの
 * オプションを扱っています。
 *
 * \subsection gui gui ディレクトリ
 *
 * gui ディレクトリ内にはダイアログやウィジェット関連のファイルが
 * 含まれています。いくつかのダイアログは %Singleton です。
 *
 * \subsubsection guiopt gui/opt ディレクトリ
 *
 * gui/opt ディレクトリでは OptionDialog クラスで使用されるウィジェットクラスを
 * 定義するファイルが含まれます。定義されているクラスは OptionWidget クラス
 * とその派生クラスです。
 *
 * opt ディレクトリ内のファイルと gui/opt ディレクトリ内のファイルは
 * 対応しています。例えば、 opt/Angles.cpp は gui/opt/AnglesOptionWidget.cpp に
 * 対応し、 opt/terminal/TerminalPostScript.h は 
 * gui/opt/terminal/TerminalPostScriptOptionWidget.h に対応します。
 *
 * \subsubsection guifit gui/fit ディレクトリ
 *
 * gui/fit ディレクトリ内では FitDialog クラスで使用される
 * ウィジェットクラスを定義するファイルが含まれます。
 *
 * \subsubsection guiplot gui/plot ディレクトリ
 *
 * gui/plot ディレクトリ内では PlotOptionDialog クラスで使用される
 * ウィジェットクラスを定義するファイルが含まれます。
 *
 * \subsection images images ディレクトリ
 *
 * images ディレクトリ内には Cueplot で用いられる画像ファイルが含まれています。
 */

#include "MainWindow.h"

#include <QtCore/QLibraryInfo>
#include <QtCore/QLocale>
#include <QtCore/QTranslator>
#include <QtGui/QApplication>

int main(int argc, char *argv[])
{
	// 設定ファイルの保存場所を指定
	QCoreApplication::setOrganizationName("SourceForge");
	QCoreApplication::setOrganizationDomain("cueplot.sourceforge.jp");
	QCoreApplication::setApplicationName("Cueplot");

	QApplication app(argc, argv);

	const QString TRANS_DIR
		= QLibraryInfo::location(QLibraryInfo::TranslationsPath);
	const QString APP_DIR
		= QCoreApplication::applicationDirPath();
	const QString LOCALE = QLocale::system().name();
	QString FILE_NAME = "qt_" + LOCALE;

	const QString PAIR[][2] = {
		// Qt ライブラリの翻訳ファイル
		{ FILE_NAME, TRANS_DIR },
		{ FILE_NAME.toLower(), TRANS_DIR },
		{ FILE_NAME, APP_DIR },
		// このアプリケーションの翻訳ファイル
		{ QCoreApplication::applicationName().toLower() + "_" + LOCALE,
			APP_DIR }
	};

	const int NUM = sizeof(PAIR) / sizeof(PAIR[0]);
	QTranslator translator[NUM];
	// 翻訳ファイルを読み込む
	for (int i = 0; i < NUM; i++) {
		translator[i].load(PAIR[i][0], PAIR[i][1]);
		app.installTranslator(&translator[i]);
	}

	MainWindow mainWindow;
	mainWindow.show();

	return app.exec();
}
