/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "TitleOptionWidget.h"
#include "Title.h"

#include <QtGui/QDoubleSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QGridLayout>

TitleOptionWidget::TitleOptionWidget(QWidget *parent)
: OptionWidget(parent), title(0)
{
	setWindowTitle(tr("Title"));
	setWhatsThis("set title");
}

TitleOptionWidget::~TitleOptionWidget()
{
	delete title;
}

void TitleOptionWidget::construct()
{
	labelLineEdit = new QLineEdit;
	connect(labelLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *textLabel = new QLabel;
	textLabel->setText(tr("T&ext:"));
	textLabel->setBuddy(labelLineEdit);

	xOffsetDoubleSpinBox = new QDoubleSpinBox;
	xOffsetDoubleSpinBox->setMinimum(-99);
	connect(xOffsetDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *xOffsetLabel = new QLabel;
	xOffsetLabel->setText(tr("&X Offset:"));
	xOffsetLabel->setBuddy(xOffsetDoubleSpinBox);

	yOffsetDoubleSpinBox = new QDoubleSpinBox;
	yOffsetDoubleSpinBox->setMinimum(-99);
	connect(yOffsetDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QLabel *yOffsetLabel = new QLabel;
	yOffsetLabel->setText(tr("&Y Offset:"));
	yOffsetLabel->setBuddy(yOffsetDoubleSpinBox);

	fontNameLineEdit = new QLineEdit;
	connect(fontNameLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	QLabel *fontNameLabel = new QLabel;
	fontNameLabel->setText(tr("&Font Name:"));
	fontNameLabel->setBuddy(fontNameLineEdit);

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(textLabel, 0, 0);
	mainLayout->addWidget(labelLineEdit, 0, 1, 1, 2);
	mainLayout->addWidget(xOffsetLabel, 1, 0);
	mainLayout->addWidget(xOffsetDoubleSpinBox, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20,
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addWidget(yOffsetLabel, 2, 0);
	mainLayout->addWidget(yOffsetDoubleSpinBox, 2, 1);
	mainLayout->addWidget(fontNameLabel, 3, 0);
	mainLayout->addWidget(fontNameLineEdit, 3, 1, 1, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 4, 0);

	setLayout(mainLayout);
}

void TitleOptionWidget::init()
{
	delete title;
	title = new Title;
	setWidget();
}

void TitleOptionWidget::apply()
{
	title->setTitleText(labelLineEdit->text());
	title->setXOffset(xOffsetDoubleSpinBox->value());
	title->setYOffset(yOffsetDoubleSpinBox->value());
	title->setFontName(fontNameLineEdit->text());
	emit executed(title->command());
}

void TitleOptionWidget::setWidget()
{
	labelLineEdit->setText(title->titleText());
	xOffsetDoubleSpinBox->setValue(title->xOffset());
	yOffsetDoubleSpinBox->setValue(title->yOffset());
	fontNameLineEdit->setText(title->fontName());
}
