/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "MAxisTicsOptionWidget.h"
#include "MAxisTics.h"

#include <QtGui/QComboBox>
#include <QtGui/QLineEdit>
#include <QtGui/QRadioButton>
#include <QtGui/QGridLayout>

MAxisTicsOptionWidget::MAxisTicsOptionWidget(QWidget *parent)
: AxisOptionWidget(parent), mAxisTics(0)
{
	setWindowTitle(tr("Mini Tics"));
	setWhatsThis(tr("set m<i>axis</i>tics"));
}

MAxisTicsOptionWidget::~MAxisTicsOptionWidget()
{
	delete mAxisTics;
}

void MAxisTicsOptionWidget::construct()
{
	AxisOptionWidget::construct();
	for (int i = 0; !MAxisTics::AXIS[i].isEmpty(); i++) {
		axisComboBox->addItem(MAxisTics::AXIS[i]);
	}
}

void MAxisTicsOptionWidget::init()
{
	delete mAxisTics;
	mAxisTics = new MAxisTics;
	AxisOptionWidget::setWidget();
}

void MAxisTicsOptionWidget::apply()
{
	AxisOptionWidget::apply();
	emit executed(mAxisTics->command());
}

void MAxisTicsOptionWidget::constructWidget(QWidget *widget)
{
	defaultRadioButton = new QRadioButton;
	defaultRadioButton->setText(tr("D&efault"));
	connect(defaultRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	freqRadioButton = new QRadioButton;
	freqRadioButton->setText(tr("&Interval"));
	connect(freqRadioButton, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	freqLineEdit = new QLineEdit;
	connect(freqRadioButton, SIGNAL(toggled(bool)),
			freqLineEdit, SLOT(setEnabled(bool)));
	connect(freqLineEdit, SIGNAL(textChanged(const QString &)),
			this, SIGNAL(modified()));

	// create and assemble layouts

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(defaultRadioButton, 0, 0);
	mainLayout->addWidget(freqRadioButton, 1, 0);
	mainLayout->addWidget(freqLineEdit, 1, 1);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 1, 2);
	mainLayout->addItem(new QSpacerItem(20, 40, 
				QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 0);

	widget->setLayout(mainLayout);
}


void MAxisTicsOptionWidget::setOption(int axis)
{
	mAxisTics->setDefault(axis, defaultRadioButton->isChecked());
	mAxisTics->setFrequency(axis, freqLineEdit->text());
}

 
void MAxisTicsOptionWidget::setWidget(int axis)
{
	bool isDefault = mAxisTics->isDefault(axis);
	defaultRadioButton->setChecked(isDefault);
	freqRadioButton->setChecked(!isDefault);
	freqLineEdit->setEnabled(!isDefault);
	freqLineEdit->setText(mAxisTics->frequency(axis));
}
