/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "LogScaleOptionWidget.h"
#include "LogScale.h"

#include <QtGui/QCheckBox>
#include <QtGui/QGridLayout>
#include <QtGui/QLineEdit>

LogScaleOptionWidget::LogScaleOptionWidget(QWidget *parent)
: OptionWidget(parent), logScale(0)
{
	setWindowTitle(tr("Log Scale"));
	setWhatsThis("set logscale");
}

LogScaleOptionWidget::~LogScaleOptionWidget()
{
	while (!logScaleCheckBoxList.isEmpty()) {
		delete logScaleCheckBoxList.takeFirst();
		delete baseLineEditList.takeFirst();
	}
	delete logScale;
}

void LogScaleOptionWidget::construct()
{
	for (int i = 0; !LogScale::AXIS[i].isEmpty(); i++) {
		QCheckBox *logScaleCheckBox = new QCheckBox;
		logScaleCheckBox->setText(LogScale::AXIS[i] + tr(" Axis"));
		connect(logScaleCheckBox, SIGNAL(toggled(bool)),
				this, SIGNAL(modified()));
		logScaleCheckBoxList.append(logScaleCheckBox);

		QLineEdit *baseLineEdit = new QLineEdit;
		connect(logScaleCheckBox, SIGNAL(toggled(bool)),
				baseLineEdit, SLOT(setEnabled(bool)));
		connect(baseLineEdit, SIGNAL(textChanged(const QString &)),
				this, SIGNAL(modified()));
		baseLineEditList.append(baseLineEdit);
	}

	QGridLayout *mainLayout = new QGridLayout;
	for (int i = 0; !LogScale::AXIS[i].isEmpty(); i++) {
		mainLayout->addWidget(logScaleCheckBoxList[i], i, 0);
		mainLayout->addWidget(baseLineEditList[i], i, 1);
	}
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 2);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding),
			logScaleCheckBoxList.size(), 0);

	setLayout(mainLayout);
}

void LogScaleOptionWidget::init()
{
	delete logScale;
	logScale = new LogScale;
	setWidget();
}
void LogScaleOptionWidget::apply()
{
	for (int i = 0; !LogScale::AXIS[i].isEmpty(); i++) {
		logScale->setLogScale(i, logScaleCheckBoxList.at(i)->isChecked());
		logScale->setBase(i, baseLineEditList.at(i)->text());
	}
	emit executed(logScale->command());
}

void LogScaleOptionWidget::setWidget()
{
	for (int i = 0; !LogScale::AXIS[i].isEmpty(); i++) {
		logScaleCheckBoxList[i]->setChecked(logScale->isLogScale(i));
		baseLineEditList[i]->setEnabled(logScale->isLogScale(i));
		baseLineEditList[i]->setText(logScale->base(i));
	}
}
