/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "EncodingOptionWidget.h"
#include "Encoding.h"

#include <QtCore/QCoreApplication>
#include <QtGui/QGridLayout>
#include <QtGui/QComboBox>

EncodingOptionWidget::EncodingOptionWidget(QWidget *parent)
: OptionWidget(parent), encoding(0)
{
	setWindowTitle(tr("Encoding"));
	setWhatsThis("set encoding");
}

EncodingOptionWidget::~EncodingOptionWidget()
{
	delete encoding;
}

void EncodingOptionWidget::construct()
{
	encodingComboBox = new QComboBox;
	for (int i = 0; Encoding::VALUE[i][0]; i++) {
		encodingComboBox->addItem(QCoreApplication::translate(
				"Encoding", Encoding::VALUE[i]));
	}
	connect(encodingComboBox, SIGNAL(activated(int)),
			this, SIGNAL(modified()));

	QGridLayout *mainLayout = new QGridLayout;
	mainLayout->addWidget(encodingComboBox, 0, 0);
	mainLayout->addItem(new QSpacerItem(40, 20, 
				QSizePolicy::Expanding, QSizePolicy::Minimum), 0, 1);
	mainLayout->addItem(new QSpacerItem(20, 40,
				QSizePolicy::Minimum, QSizePolicy::Expanding), 1, 0);

	setLayout(mainLayout);
}

void EncodingOptionWidget::init()
{
	delete encoding;
	encoding = new Encoding;
	setWidget();
}

void EncodingOptionWidget::apply()
{
	encoding->setValue(encodingComboBox->currentIndex());
	emit executed(encoding->command());
}

void EncodingOptionWidget::setWidget()
{
	encodingComboBox->setCurrentIndex(encoding->value());
}
