/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#include "BoxWidthOptionWidget.h"
#include "BoxWidth.h"

#include <QtGui/QCheckBox>
#include <QtGui/QDoubleSpinBox>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>

BoxWidthOptionWidget::BoxWidthOptionWidget(QWidget *parent)
: OptionWidget(parent), boxWidth(0)
{
	setWindowTitle(tr("Box Width"));
	setWhatsThis("set boxwidth");
}

BoxWidthOptionWidget::~BoxWidthOptionWidget()
{
	delete boxWidth;
}

void BoxWidthOptionWidget::construct()
{
	defaultCheckBox = new QCheckBox;
	defaultCheckBox->setText(tr("&Specify"));
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	absoluteCheckBox = new QCheckBox;
	absoluteCheckBox->setText(tr("\"A&bsolute\" Value"));
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			absoluteCheckBox, SLOT(setEnabled(bool)));
	connect(absoluteCheckBox, SIGNAL(toggled(bool)),
			this, SIGNAL(modified()));

	boxWidthDoubleSpinBox = new QDoubleSpinBox;
	boxWidthDoubleSpinBox->setMinimum(-99);
	connect(defaultCheckBox, SIGNAL(toggled(bool)),
			boxWidthDoubleSpinBox, SLOT(setEnabled(bool)));
	connect(boxWidthDoubleSpinBox, SIGNAL(valueChanged(double)),
			this, SIGNAL(modified()));

	QHBoxLayout *boxWidthLayout = new QHBoxLayout;
	boxWidthLayout->addWidget(defaultCheckBox);
	boxWidthLayout->addWidget(absoluteCheckBox);
	boxWidthLayout->addWidget(boxWidthDoubleSpinBox);
	boxWidthLayout->addStretch();

	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addLayout(boxWidthLayout);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

void BoxWidthOptionWidget::init()
{
	delete boxWidth;
	boxWidth = new BoxWidth;
	setWidget();
}

void BoxWidthOptionWidget::apply()
{
	boxWidth->setWidth(boxWidthDoubleSpinBox->value());
	boxWidth->setAbsolute(absoluteCheckBox->isChecked());
	boxWidth->setAuto(!defaultCheckBox->isChecked());

	emit executed(boxWidth->command());
}

void BoxWidthOptionWidget::setWidget()
{	
	bool flag = boxWidth->isAuto();
	defaultCheckBox->setChecked(!flag);
	boxWidthDoubleSpinBox->setEnabled(!flag);
	absoluteCheckBox->setEnabled(!flag);

	boxWidthDoubleSpinBox->setValue(boxWidth->width());
	absoluteCheckBox->setChecked(boxWidth->isAbsolute());
}
