/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef AXIS_OPTION_WIDGET_INCLUDED
#define AXIS_OPTION_WIDGET_INCLUDED

#include "OptionWidget.h"

class QComboBox;

class AxisOptionWidget : public OptionWidget
{
	Q_OBJECT

	public:
		explicit AxisOptionWidget(QWidget *parent = 0);
		virtual ~AxisOptionWidget();

		virtual void construct();

	protected:
		virtual void apply();
		void setWidget();
		virtual void constructWidget(QWidget *widget) = 0;
		virtual void setOption(int axis) = 0;
		virtual void setWidget(int axis) = 0;
		int prevAxis;
		QComboBox *axisComboBox;

	private slots:
		 void changeAxis(int axis);

	private:
		// don't implement these
		AxisOptionWidget(const AxisOptionWidget &);
		AxisOptionWidget &operator=(const AxisOptionWidget &);
};
#endif // AXIS_OPTION_WIDGET_INCLUDED
