/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef AXIS_LABEL_OPTION_WIDGET_INCLUDED
#define AXIS_LABEL_OPTION_WIDGET_INCLUDED

#include "AxisOptionWidget.h"

class AxisLabel;

class QDoubleSpinBox;
class QLineEdit;

class AxisLabelOptionWidget : public AxisOptionWidget
{
	Q_OBJECT

	public:
		explicit AxisLabelOptionWidget(QWidget *parent = 0);
		~AxisLabelOptionWidget();

		void construct();

	private:
		// don't implement these
		AxisLabelOptionWidget(const AxisLabelOptionWidget &);
		AxisLabelOptionWidget &operator=(const AxisLabelOptionWidget &);

		void init();
		void apply();
		void constructWidget(QWidget *widget);
		void setOption(int axis);
		void setWidget(int axis);
		AxisLabel *axisLabel;
		QLineEdit *labelLineEdit;
		QDoubleSpinBox *xOffsetDoubleSpinBox;
		QDoubleSpinBox *yOffsetDoubleSpinBox;
		QLineEdit *fontNameLineEdit;
};
#endif // AXIS_LABEL_OPTION_WIDGET_INCLUDED
