/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef OPTION_DIALOG_INCLUDED
#define OPTION_DIALOG_INCLUDED

class OptionWidget;

#include <QtCore/QBitArray>
#include <QtGui/QDialog>
class QCloseEvent;
class QListWidget;
class QListWidgetItem;
class QDialog;
class QStackedWidget;

//! 設定ダイアログ (Singleton)
class OptionDialog : public QDialog
{
	Q_OBJECT

	public:
		static OptionDialog &instance(QWidget *parent = 0);
		static void destroyInstance();

    private slots:
		//! 設定を適用してダイアログを閉じる
		void accept();
		//! 設定を適用する
		void apply();
		//! 設定を破棄してダイアログを閉じる
		void reject();
		//! 設定を初期化する
		void init();
        void changePage(QListWidgetItem *current, QListWidgetItem *previous);
		//! 設定に変更が加えられたことにする
		void setModified();

	signals:
		//! コマンドを実行する
		/*!
		 * \param command 実行するコマンド
		 */
		void executed(const QString &command);

	private:
		OptionDialog(QWidget *parent = 0);
		// don't implement these
		OptionDialog(const OptionDialog &);
		OptionDialog &operator=(const OptionDialog &);

		//! 設定を破棄する
		void discard(OptionWidget *optionWidget);
		void closeEvent(QCloseEvent *e);
		static OptionDialog *instance_;
		QListWidget *contentsListWidget;
		QStackedWidget *pagesStackedWidget;
		//! 設定項目のウィジェットが初期化済みか調べるのに使う配列
		QBitArray initBitArray;
};

#endif // OPTION_DIALOG_INCLUDED
