/*
 * Cueplot: a GUI front-end to gnuplot
 * Copyright (C) 2007 Muneyuki Noguchi
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef FIT_INCLUDED
#define FIT_INCLUDED

#include "Command.h"
#include "FitRange.h"
#include "FitModifier.h"

#include <QtCore/QString>
#include <QtCore/QStringList>

//! fit コマンド
class Fit : public Command
{
	public:
		Fit();

		void setRange(const FitRange &range);
		const FitRange &range() const;

		void setFunction(const QString &function);
		const QString &function() const;

		void setDataFile(const QString &file);
		const QString &dataFile() const;

		void setDataFileModifier(const FitModifier &mod);
		const FitModifier &dataFileModifier() const;

		void setParameterFile(bool isFile);
		bool isParameterFile() const;

		void setParameterFile(const QString &file);
		const QString &parameterFile() const;

		void setVariable(const QStringList &var);
		const QStringList &variable() const;

		void setFitLimit(double limit);
		double fitLimit() const;

		void setFitMaxIter(int iter);
		int fitMaxIter() const;

		QString command() const;

	private:
		static const double DEFAULT_FIT_LIMIT;
		static const int DEFAULT_FIT_MAX_ITER = 0;
		FitRange range_;
		QString function_;
		QString dataFile_;
		FitModifier dataFileModifier_;
		bool isParameterFile_;
		QString parameterFile_;
		QStringList variable_;
		double fitLimit_;
		int fitMaxIter_;
};

#endif // FIT_INCLUDED
