/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.AnalyzeCodeCM;
import analyzecodeC.MyUtil;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.LoopBlock;
import analyzecodeC.decode.ProcessBlock;
import analyzecodeC.decode.StructBlock;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.ErlangCreator;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.Arrays;

public class ProcessBlockMarge
implements Serializable {
    private static final long serialVersionUID = 201002060026000001L;
    private String funcname;
    private Pbset[] pbset;
    private int counter = 0;

    public ProcessBlockMarge(String fname) {
        this.funcname = fname;
    }

    public void first() {
        this.counter = 0;
    }

    public boolean hasNext() {
        return this.pbset != null && this.pbset.length > this.counter;
    }

    public int next() {
        int retval = this.counter++;
        return retval;
    }

    public int getNest() {
        return this.pbset[this.counter].getNest();
    }

    public String getLoopFunc(EditBuffer retval, ElementOutput output) {
        output.clean();
        output.clearRamdPara();
        LoopBlock lb = this.pbset[this.counter].getLoopBlock();
        if (lb == null) {
            return "";
        }
        if (this.pbset[this.counter].childBlockInd) {
            return "";
        }
        this.preLoop();
        this.pbset[this.counter].getFuncBodyLoop(this.funcname, output, retval);
        return retval.toString();
    }

    public String getStructFunc(EditBuffer retval, ElementOutput output) {
        output.clean();
        output.clearRamdPara();
        StructBlock sb = this.pbset[this.counter].getStructBlock();
        if (sb == null || sb.isEmptyLine()) {
            return "";
        }
        ErlangCreator.getFuncTopStru(this.funcname + this.pbset[this.counter].getMyname(), sb.getInput().toErlang(output), retval);
        sb.getFuncBody(retval, output);
        return retval.toString();
    }

    public String getBasicFunc(EditBuffer retval, ElementOutput output) {
        int[] casenos = this.pbset[this.counter].getCaseno();
        if (casenos.length <= 1) {
            return "";
        }
        for (int i = 0; i < casenos.length; ++i) {
            output.clean();
            output.clearRamdPara();
            BasicBlock bb = this.pbset[this.counter].getBasicBlock(casenos[i]);
            if (bb == null) continue;
            String fname = this.funcname + this.pbset[this.counter].getMyname();
            ErlangCreator.getFuncTopBB(fname, bb.getInput().toErlang(output), casenos[i], retval);
            boolean creb = bb.getFuncBody(output, retval, true);
            if (!creb || casenos.length <= i + 1) continue;
            retval.setLineEndSN();
        }
        retval.setFuncEnd();
        return retval.toString();
    }

    private void preLoop() {
        MyUtil.PrimitiveArrayI loopidx = new MyUtil.PrimitiveArrayI();
        for (int i = 0; i < this.pbset.length; ++i) {
            if (!this.pbset[i].isLoop()) continue;
            loopidx.add(i);
        }
        loopidx.last();
        while (loopidx.hasPrevious()) {
            boolean out;
            int idx = loopidx.previous();
            Pbset befor = this.pbset[idx];
            for (int i = idx + 1; i < this.pbset.length && (out = this.pbset[i].chkLinkLoopBlock(befor)); ++i) {
                befor = this.pbset[i];
            }
        }
    }

    public String getPFuncCallList(ElementOutput output, EditBuffer retval) {
        boolean creb = false;
        for (int i = 0; i < this.pbset.length; ++i) {
            creb = this.pbset[i].getParentCodeIgnLoop(this.funcname, output, retval, i == this.pbset.length - 1);
        }
        retval.setFuncEnd();
        return retval.toString();
    }

    public void putPB(ProcessBlock[] pb) {
        if (this.pbset == null) {
            this.pbset = new Pbset[pb.length];
            for (int i = 0; i < this.pbset.length; ++i) {
                this.pbset[i] = new Pbset(pb[i]);
            }
            return;
        }
        int start = 0;
        for (int i = 0; i < pb.length; ++i) {
            int same = this.srStartPoint(start, pb[i]);
            if (same < 0) {
                if (!this.pbset[start].addPb(pb[i])) {
                    this.pbset[start].addPb(null);
                }
                ++start;
                continue;
            }
            if (start != same) {
                for (int j = start; j < same; ++j) {
                    this.pbset[j].addPb(null);
                }
                start = same;
                continue;
            }
            ++start;
        }
    }

    private int srStartPoint(int start, ProcessBlock pb) {
        int i;
        for (i = start; i < this.pbset.length && !this.pbset[i].isEqPb(pb); ++i) {
        }
        if (i == this.pbset.length) {
            return -1;
        }
        return i;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("funcname=" + this.funcname + "\n");
        if (this.pbset == null) {
            retval.append("pbset null\n");
        } else {
            for (int i = 0; i < this.pbset.length; ++i) {
                retval.append("Pbset[" + i + "]\n");
                retval.append(this.pbset[i].toLog());
            }
        }
        return retval.toString();
    }

    private class Pbset {
        private ProcessBlock[] pbs = new ProcessBlock[1];
        private boolean childBlockInd = false;
        private Pbset nextloopBlock = null;
        private LoopBlock getloop;
        private StructBlock getsb;
        private BasicBlock[] getbb = new BasicBlock[1];

        private Pbset(ProcessBlock pb) {
            this.pbs[0] = pb;
        }

        private String toLog() {
            StringBuffer retval = new StringBuffer();
            for (int i = 0; i < this.pbs.length; ++i) {
                retval.append("ProcessBlock[" + i + "]\n");
                retval.append(this.pbs[i].toLog());
            }
            return retval.toString();
        }

        private boolean linkLoopBlock(Pbset next) {
            if (next.childBlockInd) {
                return false;
            }
            this.nextloopBlock = next;
            next.childBlockInd = true;
            return true;
        }

        private boolean chkLinkLoopBlock(Pbset befor) {
            if (this.getNest() > befor.getNest()) {
                return befor.linkLoopBlock(this);
            }
            return false;
        }

        private void getFuncBodyLoop(String funcname, ElementOutput output, EditBuffer retval) {
            Pbset next = this;
            while (next != null) {
                LoopBlock lbn = next.getLoopBlock();
                this.addInputAllMemObjCBlock();
                String nfname = funcname + next.getMyname();
                lbn.getFuncBodyTop(nfname, output, retval);
                next.getBBcodeOrBBST(nfname, output, retval, false);
                boolean smp = false;
                if (next.nextloopBlock != null) {
                    smp = next.nextloopBlock.getSMP_Flg() && AnalyzeCodeCM.AUTO_SMP;
                    boolean out = next.nextloopBlock.getParentCodeCallLoop(funcname, output, retval, smp, true);
                }
                output.clearRamdParaVal();
                lbn.getFuncBodyEnd(nfname, output, retval, smp);
                output.clearRamdPara();
                next = next.nextloopBlock;
            }
        }

        private void addInputAllMemObjCBlock() {
            LoopBlock outlbn = this.getLoopBlock();
            boolean child = false;
            Pbset next = this;
            while (next != null) {
                BasicBlock cbb;
                StructBlock csb;
                LoopBlock clb = next.getLoopBlock();
                if (clb != null && child) {
                    outlbn.addBBinput(clb.getInput());
                }
                if ((csb = next.getStructBlock()) != null) {
                    outlbn.addBBinput(csb.getInput());
                }
                if ((cbb = next.getBasicBlock(1)) != null) {
                    outlbn.addBBinput(cbb.getInput());
                }
                next = next.nextloopBlock;
                child = true;
            }
        }

        private boolean getParentCodeIgnLoop(String funcname, ElementOutput output, EditBuffer retval, boolean ramdaend) {
            if (this.childBlockInd) {
                return false;
            }
            return this.getParentCodeCallLoop(funcname, output, retval, false, ramdaend);
        }

        private boolean getParentCodeCallLoop(String funcname, ElementOutput output, EditBuffer retval, boolean smp, boolean ramdaend) {
            if (this.isLoop()) {
                String fname = funcname + this.getMyname();
                LoopBlock lb = this.getLoopBlock();
                this.addInputAllMemObjCBlock();
                return lb.getCallFuncBody(fname, output, retval, smp);
            }
            return this.getBBcodeOrBBST(funcname, output, retval, ramdaend);
        }

        private boolean getBBcodeOrBBST(String funcname, ElementOutput output, EditBuffer retval, boolean ramdaend) {
            boolean creb = false;
            int[] bbno = this.getCaseno();
            if (bbno.length == 1) {
                BasicBlock bb = this.getBasicBlock(bbno[0]);
                if (bb == null) {
                    return false;
                }
                creb = bb.getFuncBody(output, retval, ramdaend);
            } else {
                creb = this.getBBSTcode(funcname, output, retval);
            }
            return creb;
        }

        private boolean getBBSTcode(String funcname, ElementOutput output, EditBuffer retval) {
            InputMemnames inputb = this.getMargeBasicBlockInput();
            String fname = funcname + this.getMyname();
            StructBlock sb = this.getStructBlock();
            if (sb == null) {
                ErlangCreator.getFuncCallLine(fname, inputb.toErlang(output), "", retval);
            } else {
                InputMemnames inputs = sb.getInput();
                ErlangCreator.getFuncCallLine(fname, inputb.toErlang(output), inputs.toErlang(output), retval);
            }
            return true;
        }

        private boolean isLoop() {
            if (this.pbs.length != 1) {
                return false;
            }
            return this.pbs[0].isLoop();
        }

        private boolean getSMP_Flg() {
            if (this.pbs.length != 1) {
                return false;
            }
            return this.pbs[0].chkSMP();
        }

        private int getNest() {
            return this.pbs[0].getNest();
        }

        private String getMyname() {
            return new Integer(this.pbs[0].getBlockno()).toString();
        }

        private boolean isEqPb(ProcessBlock pb) {
            for (int i = 0; i < this.pbs.length; ++i) {
                if (this.pbs[i].getBlockno() != pb.getBlockno()) continue;
                return true;
            }
            return false;
        }

        private boolean addPb(ProcessBlock pb) {
            this.getsb = null;
            this.getbb = null;
            this.getloop = null;
            if (pb == null) {
                pb = new ProcessBlock(-1, null);
            } else {
                if (this.pbs[0].getNest() < 0) {
                    return true;
                }
                if (this.pbs[0].getNest() != pb.getNest()) {
                    return false;
                }
            }
            Object[] work = new ProcessBlock[this.pbs.length + 1];
            System.arraycopy(this.pbs, 0, work, 0, this.pbs.length);
            work[work.length - 1] = pb;
            Arrays.sort(work);
            this.pbs = work;
            this.getbb = new BasicBlock[this.pbs.length];
            return true;
        }

        private LoopBlock getLoopBlock() {
            if (!this.isLoop()) {
                return null;
            }
            if (this.getloop != null) {
                return this.getloop;
            }
            if (this.pbs.length != 1) {
                throw new IllegalStateException();
            }
            CtoErlangTrans[] lines = this.pbs[0].getLines();
            this.getloop = LoopBlock.getLoopBlock(lines, this.pbs[0].getPk());
            return this.getloop;
        }

        private StructBlock getStructBlock() {
            if (this.getsb != null) {
                return this.getsb;
            }
            StructBlock retval = new StructBlock();
            InputMemnames input = new InputMemnames();
            if (this.pbs.length == 1) {
                if (this.pbs[0].getBlockno() < 0 || !this.pbs[0].isCondition()) {
                    return null;
                }
                this.pbs[0].getInput(input, true);
                this.pbs[0].getStructBlock(retval, 1);
            } else {
                for (int i = 0; i < this.pbs.length; ++i) {
                    if (this.pbs[i].getBlockno() < 0) continue;
                    this.pbs[i].getInput(input, true);
                    this.pbs[i].getStructBlock(retval, i + 1);
                }
            }
            retval.setInput(input);
            this.getsb = retval;
            return retval;
        }

        private int[] getCaseno() {
            int size = 0;
            for (int i = 0; i < this.pbs.length; ++i) {
                if (this.pbs[i].getBlockno() < 0) continue;
                ++size;
            }
            int[] retval = new int[size];
            size = 0;
            for (int i = 0; i < this.pbs.length; ++i) {
                if (this.pbs[i].getBlockno() < 0) continue;
                retval[size++] = i + 1;
            }
            return retval;
        }

        private InputMemnames getMargeBasicBlockInput() {
            InputMemnames input = new InputMemnames();
            int[] cnos = this.getCaseno();
            for (int i = 0; i < cnos.length; ++i) {
                this.pbs[cnos[i] - 1].getInput(input, false);
            }
            return input;
        }

        private BasicBlock getBasicBlock(int caseno) {
            if (this.getbb[caseno - 1] != null) {
                return this.getbb[caseno - 1];
            }
            BasicBlock retval = this.pbs[caseno - 1].getBasicBlock();
            if (retval == null) {
                return null;
            }
            retval.creInput();
            this.getbb[caseno - 1] = retval;
            return retval;
        }
    }
}

