/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class InputMemnames
implements Serializable {
    private static final long serialVersionUID = 201002060004000001L;
    private int size = 0;
    private InputPara top;
    private InputPara tail;

    public String[] getparas() {
        ArrayList<String> retval = new ArrayList<String>();
        InputPara out = this.top;
        while (out != null) {
            retval.add(out.para.getMyKey());
            out = out.next;
        }
        String[] names = new String[retval.size()];
        retval.toArray(names);
        return names;
    }

    public void updateParaname(ElementOutput output) {
        InputPara out = this.top;
        while (out != null) {
            String symb = out.para.getMyKey();
            output.commitRamdParaName(symb);
            out = out.next;
        }
    }

    public String toErlang(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        MemObjects mojs = output.getPk().getInmems();
        String[] paras = this.getparas();
        paras = mojs.sortRamdaparaNames(paras);
        boolean edited = false;
        for (int i = 0; i < paras.length; ++i) {
            String symb = paras[i];
            MemObject mo = mojs.getMemObjectFromAll(symb);
            if (mo.getArraydat() != null || mojs.isExtMo(symb)) continue;
            if (edited) {
                retval.append(",");
            }
            Element ele = output == null ? null : output.getRamdParaVal(symb);
            String nowname = null;
            if (ele != null) {
                nowname = ele.toErlang(output);
            } else {
                String lower = symb.substring(1);
                String upper = symb.substring(0, 1);
                nowname = upper.toUpperCase() + lower;
            }
            retval.append(nowname);
            edited = true;
        }
        return retval.toString();
    }

    public String toErlang(MemObjects inmems) {
        StringBuffer retval = new StringBuffer();
        String[] paras = this.getparas();
        paras = inmems.sortRamdaparaNames(paras);
        boolean edited = false;
        for (int i = 0; i < paras.length; ++i) {
            MemObject mo = inmems.getMemObjectFromAll(paras[i]);
            if (mo.getArraydat() != null) continue;
            if (edited) {
                retval.append(",");
            }
            String symb = paras[i];
            String lower = symb.substring(1);
            String upper = symb.substring(0, 1);
            String nowname = upper.toUpperCase() + lower;
            retval.append(nowname);
            edited = true;
        }
        return retval.toString();
    }

    public String getTaple(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        retval.append("{");
        retval.append(this.toErlang(output.getPk().getInmems()));
        retval.append("}");
        return retval.toString();
    }

    public String getTapleRamda(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        retval.append("{");
        String[] paras = this.getparas();
        paras = output.getPk().getInmems().sortRamdaparaNames(paras);
        boolean edited = false;
        for (int i = 0; i < paras.length; ++i) {
            MemObject mo = output.getPk().getInmems().getMemObjectFromAll(paras[i]);
            if (mo == null || mo.getArraydat() != null) continue;
            if (edited) {
                retval.append(",");
            }
            Element ele = output.getRamdParaVal(paras[i]);
            String rename = output.getNowRamdParaName(paras[i]);
            if (ele != null) {
                retval.append(ele.optiToErlang(paras[i], rename));
            } else {
                String lower = rename.substring(1);
                String upper = rename.substring(0, 1);
                rename = upper.toUpperCase() + lower;
                retval.append(rename);
            }
            edited = true;
        }
        retval.append("}");
        return retval.toString();
    }

    public static InputMemnames reduce(InputMemnames source, InputMemnames del) {
        InputMemnames retval = new InputMemnames();
        InputPara sr = source.top;
        while (sr != null) {
            retval.putInput(sr.para);
            sr = sr.next;
        }
        sr = del.top;
        while (sr != null) {
            retval.remove(sr.para);
            sr = sr.next;
        }
        return retval;
    }

    public void putInput(InputMemnames in) {
        InputPara sr = in.top;
        while (sr != null) {
            this.putInput(sr.para);
            sr = sr.next;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputMemnames other = (InputMemnames)obj;
        if (this.size != other.size) {
            return false;
        }
        InputPara sr = this.top;
        while (sr != null) {
            if (!((InputMemnames)obj).contain(sr.para)) {
                return false;
            }
            sr = sr.next;
        }
        sr = ((InputMemnames)obj).top;
        while (sr != null) {
            if (!this.contain(sr.para)) {
                return false;
            }
            sr = sr.next;
        }
        return true;
    }

    public void putInput(MemObject sin) {
        ArrayList<MemObject> mems = sin.collectMemobj();
        Iterator<MemObject> it = mems.iterator();
        while (it.hasNext()) {
            this.paraChainAttach(it.next());
        }
    }

    private void paraChainAttach(MemObject sin) {
        if (this.top == null) {
            this.tail = this.top = new InputPara(sin, 0);
        } else {
            if (this.contain(sin)) {
                return;
            }
            this.tail.next = new InputPara(sin, 0);
            this.tail = this.tail.next;
        }
        ++this.size;
    }

    public boolean contain(MemObject sin) {
        InputPara sr = this.top;
        while (sr != null) {
            if (sr.para.getMyKey().equals(sin.getMyKey())) {
                return true;
            }
            sr = sr.next;
        }
        return false;
    }

    public boolean remove(MemObject del) {
        boolean retval = false;
        InputPara sr = this.top;
        InputPara befor = null;
        while (sr != null) {
            if (sr.para.equals(del)) {
                if (befor != null) {
                    befor.next = sr.next;
                } else {
                    this.top = sr.next;
                }
                --this.size;
                retval = true;
            } else {
                befor = sr;
            }
            sr = sr.next;
        }
        return retval;
    }

    public int getSize() {
        return this.size;
    }

    public void creInput(CtoErlangTrans cet, ProcessKakko pk) {
        MemObjects mos = pk.getInmems();
        ArrayList<MemObject> refmos = cet.getRefMemObj();
        for (MemObject mo : refmos) {
            if (mos.isExtMo(mo.getMyKey())) continue;
            this.putInput(mo);
        }
    }

    private class InputPara
    implements Serializable {
        private static final long serialVersionUID = 201003050004000001L;
        private static final int NORMAL = 0;
        private static final int LIST = 1;
        private static final int TAPLE = 2;
        private static final int FUNC = 3;
        private int type = 0;
        private MemObject para;
        private InputPara next;

        private InputPara(MemObject paraname, int paratype) {
            this.para = paraname;
            this.type = paratype;
        }
    }
}

