/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ErlangCreator;
import java.io.Serializable;
import java.util.HashMap;

public class ElementOutput
extends Element
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060024000001L;
    private ProcessKakko pk;
    private HashMap extmobjs = null;
    private int size = 0;
    private OutputPara top;
    private OutputPara tail;
    private RamdaPara toprpara;
    private boolean commitflg = false;

    public ElementOutput(ProcessKakko kakko) {
        if (kakko == null) {
            throw new NullPointerException();
        }
        this.pk = kakko;
        MemObjects pmb = this.pk.getInmems();
        this.extmobjs = pmb.getExtmobjs();
    }

    public ProcessKakko getPk() {
        return this.pk;
    }

    public boolean isExtmem(String sym) {
        return this.extmobjs.get(sym) != null;
    }

    public String toErlang() {
        StringBuffer retval = new StringBuffer();
        OutputPara out = this.top;
        while (out != null) {
            String symb = out.para;
            String lower = symb.substring(1);
            String upper = symb.substring(0, 1);
            retval.append(upper.toUpperCase() + lower);
            if (out.next != null) {
                retval.append(",");
            }
            out = out.next;
        }
        retval.append(super.toErlang());
        return retval.toString();
    }

    public boolean toErlangRamdPara(EditBuffer output) {
        boolean retval = false;
        RamdaPara op = this.toprpara;
        while (op != null) {
            String vname = op.name;
            if (op.getupdateval || op.getRamdaVal() == null) {
                op = op.next;
                continue;
            }
            MemObject mo = this.pk.getInmems().getMemObject(vname);
            if (mo == null) {
                throw new Error();
            }
            Element ele = new Element(mo);
            ele.setEleB("=");
            ele.setEleC(op.getRamdaVal());
            ele.setExtflg(this);
            output.append(ele.toErlang());
            op = op.next;
            if (op != null) {
                output.setLineEndKN();
            }
            retval = true;
        }
        return retval;
    }

    public void clean() {
        this.top = null;
    }

    public void putOutput(String sin) {
        if (sin == null || sin.length() == 0) {
            return;
        }
        if (this.top == null) {
            this.tail = this.top = new OutputPara(sin, 0);
        } else {
            this.tail.next = new OutputPara(sin, 0);
            this.tail = this.tail.next;
        }
        ++this.size;
    }

    public boolean containOutput(String val) {
        OutputPara op = this.top;
        while (op != null) {
            if (op.para.equals(val)) {
                return true;
            }
            op = op.next;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public void clearRamdPara() {
        this.toprpara = null;
    }

    public void clearRamdParaVal() {
        RamdaPara op = this.toprpara;
        while (op != null) {
            op.clearVal();
            op = op.next;
        }
    }

    private RamdaPara addRamdaPara(String sin) {
        if (this.getRamdaPara(sin) != null) {
            return null;
        }
        if (this.toprpara == null) {
            this.toprpara = new RamdaPara(sin);
        } else {
            RamdaPara out = new RamdaPara(sin);
            out.next = this.toprpara;
            this.toprpara = out;
        }
        return this.toprpara;
    }

    private RamdaPara getRamdaPara(String val) {
        RamdaPara op = this.toprpara;
        while (op != null) {
            if (op.name.equals(val)) {
                return op;
            }
            op = op.next;
        }
        return null;
    }

    public boolean updateRamdParaVal(Element ele) {
        String memobjsy = ele.getEleASym();
        if (!ele.isSetSent() || memobjsy == null || memobjsy.equals("")) {
            return false;
        }
        if (ele.getEleAMemObj().getArraydat() != null) {
            return false;
        }
        RamdaPara rp = this.getRamdaPara(memobjsy);
        if (rp == null) {
            rp = this.addRamdaPara(memobjsy);
        }
        Element smeth = ele.getSetMethod();
        smeth.setExtflg(this);
        rp.setVal(smeth);
        return true;
    }

    public Element getRamdParaVal(String sym) {
        RamdaPara rp = this.getRamdaPara(sym);
        if (rp == null) {
            return null;
        }
        return rp.getRamdaVal();
    }

    public void commitRamdParaName(String sym) {
        RamdaPara rp = this.getRamdaPara(sym);
        if (rp == null) {
            rp = this.addRamdaPara(sym);
        }
        rp.commit();
    }

    public String getNowRamdParaName(String sym) {
        RamdaPara rp = this.getRamdaPara(sym);
        if (rp == null) {
            return ErlangCreator.valCToErl(sym);
        }
        if (rp.commit == 0) {
            return ErlangCreator.valCToErl(sym);
        }
        String retval = sym + new Integer(rp.commit).toString();
        return ErlangCreator.valCToErl(retval);
    }

    public void opti(String syname) {
        this.opti(this.getRamdaPara(syname));
    }

    private void opti(RamdaPara uprp) {
        if (uprp == null) {
            return;
        }
        RamdaPara op = this.toprpara;
        while (op != null) {
            if (op != uprp) {
                op.updateVal(uprp);
            }
            op = op.next;
        }
    }

    private class RamdaPara
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 201003050024000066L;
        private RamdaPara next;
        private String name;
        private Element val;
        private Element updateval;
        private int commit = 0;
        private boolean getupdateval = false;

        private RamdaPara(String paraname) {
            this.name = paraname;
        }

        private void setVal(Element value) {
            this.val = value;
            try {
                this.updateval = (Element)this.val.clone();
                this.getupdateval = false;
            }
            catch (CloneNotSupportedException ce) {
                throw new Error();
            }
        }

        private void clearVal() {
            if (ElementOutput.this.commitflg) {
                this.val = null;
                this.updateval = null;
                ElementOutput.this.commitflg = false;
                this.getupdateval = false;
            }
        }

        private boolean commit() {
            ++this.commit;
            ElementOutput.this.commitflg = true;
            return true;
        }

        private Element getRamdaVal() {
            this.getupdateval = true;
            return this.updateval;
        }

        private void updateVal(RamdaPara rp) {
            this.updateval.firstMemObj();
            boolean ret = this.updateval.nextMemObj();
            while (ret) {
                String sym = this.updateval.getMemObjSym();
                if (sym.equals(rp.name)) {
                    this.updateval.setValue(rp.updateval);
                }
                ret = this.updateval.nextMemObj();
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private class OutputPara
    implements Cloneable,
    Serializable {
        private static final int NORMAL = 0;
        private static final int LIST = 1;
        private static final int TAPLE = 2;
        private static final int FUNC = 3;
        private int type = 0;
        private String para;
        private OutputPara next;
        private static final long serialVersionUID = 201003050024000055L;

        private OutputPara(String paraname, int paratype) {
            this.para = paraname;
            this.type = paratype;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

