/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.Guardtype;
import java.io.Serializable;

public class ElementGuard
extends Element
implements Guardtype,
Serializable {
    private static final long serialVersionUID = 201002060023000001L;
    private Element express;
    private String ifstr;

    public void setExpress(Element expressions) {
        this.express = expressions;
    }

    public Element getExpress() {
        return this.express;
    }

    public String getGuardErl() {
        return "case ";
    }

    public String getGuardErlEnd() {
        return "end";
    }

    public String toErlang(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        if (this.ifstr.equals("if")) {
            if (this.express instanceof Guardtype) {
                retval.append(super.toErlang(output));
                retval.append(",\n ");
                this.express.toErlang(output);
                retval.append(" of\n ");
            } else {
                retval.append(super.toErlang(output) + " of\n");
                retval.append("    true ->\n");
                retval.append("      " + this.express.toErlang(output));
            }
        } else if (this.ifstr.equals("else")) {
            retval.append("    false ->\n");
            retval.append("      " + this.express.toErlang(output));
        }
        return retval.toString();
    }

    public static ElementGuard creElementElse(CtoErlangTrans a) {
        if (!a.isStructLine() || !a.getString().equals("else")) {
            return null;
        }
        return ElementGuard.newInstance("else", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElementGuard creElementIf(CtoErlangTrans a, CtoErlangTrans b, CtoErlangTrans line) {
        ElementGuard retval = null;
        line.setNextUseCET(null);
        if (!a.isStructLine() || !a.getString().equals("if")) {
            return null;
        }
        if (!b.getString().equals("(")) {
            return null;
        }
        CtoErlangTrans para = line.getNext();
        if (para != null && para.getString() != null && para.getString().equals(")")) {
            Element el = line.thinkEle();
            retval = ElementGuard.newInstance("if", el);
            line.setNextUseCET(para.getNext());
            return retval;
        }
        if (para == null || line.getString() != null && line.getString().equals(")")) return null;
        Element eb = Element.newInstanceBase(para);
        if (eb == null) return null;
        CtoErlangTrans next = para.getNextUseCET();
        if (next.getString() != null && next.getString().equals(")")) {
            retval = ElementGuard.newInstance("if", eb);
        }
        line.setNextUseCET(next.getNext());
        return retval;
    }

    private static ElementGuard newInstance(String type, Element cond) {
        ElementGuard retval = new ElementGuard();
        if (cond == null) {
            retval.setEleA("");
        } else {
            retval.setEleA(cond);
        }
        retval.ifstr = type;
        return retval;
    }
}

