/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.AnalyzeCodeCM;
import analyzecodeC.decode.Function;
import analyzecodeC.decode.MemObject;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFunc
extends Element
implements Serializable {
    private static final long serialVersionUID = 201002060022000001L;
    private String funcname = null;
    private ExePara para = null;

    private ElementFunc() {
    }

    public ElementFunc(String name, int parasize) {
        this.funcname = name;
        this.para = new ExePara();
        if (!AnalyzeCodeCM.addFunc(this.funcname, parasize)) {
            AnalyzeCodeCM.getFuncData(this.funcname).modParasize(parasize);
        }
    }

    public void addPara(CtoErlangTrans inpara) {
        this.para.addPara(inpara);
    }

    public void addPara(ElementFunc inpara) {
        this.para.addPara(inpara);
    }

    @Override
    public String toErlang(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        Function func = AnalyzeCodeCM.getFuncData(this.funcname);
        retval.append(func.getErlFuncCall() + "(");
        retval.append(this.para.toErlang());
        retval.append(")");
        retval.append(super.toErlang(output));
        return retval.toString();
    }

    @Override
    public String toErlang() {
        StringBuffer retval = new StringBuffer();
        Function func = AnalyzeCodeCM.getFuncData(this.funcname);
        retval.append(func.getErlFuncCall() + "(");
        retval.append(this.para.toErlang());
        retval.append(")");
        retval.append(super.toErlang());
        return retval.toString();
    }

    public static ElementFunc creElementFunc(CtoErlangTrans a, CtoErlangTrans b, CtoErlangTrans line) {
        if (a.getString() == null || b.getString() == null || !b.getString().equals("(")) {
            return null;
        }
        ElementFunc retval = new ElementFunc();
        retval.funcname = a.getString();
        retval.para = new ExePara();
        if (!retval.para.crePara(line)) {
            return null;
        }
        AnalyzeCodeCM.addFunc(retval.funcname, retval.para.exeparas.size());
        return retval;
    }

    @Override
    public void setExtflg(ElementOutput output) {
        this.para.paraChgpre(output);
    }

    @Override
    public void collectMemobj(ArrayList<MemObject> output) {
        this.para.collectMemobj(output);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExePara
    implements Serializable {
        private ArrayList<ParaPart> exeparas = new ArrayList();
        private ArrayList<String> erlexeparas;
        private static final long serialVersionUID = 201003050022000031L;

        private ExePara() {
        }

        private void addPara(CtoErlangTrans addcet) {
            ParaPart pp = new ParaPart(addcet);
            this.exeparas.add(pp);
        }

        private void addPara(ElementFunc addfunc) {
            ParaPart pp = new ParaPart(addfunc);
            this.exeparas.add(pp);
        }

        private boolean crePara(CtoErlangTrans line) {
            boolean retval = false;
            CtoErlangTrans getcet = line;
            ParaPart bef = null;
            while (getcet != null) {
                String str = getcet.getString();
                if (str != null) {
                    if (str.equals(")")) {
                        if (bef != null) {
                            this.exeparas.add(bef);
                        }
                        getcet = getcet.getNext();
                        line.setNextUseCET(getcet);
                        retval = true;
                        break;
                    }
                    if (str.equals("(")) {
                        if (bef == null) {
                            new Error();
                        }
                        ElementFunc outf = ElementFunc.creElementFunc(bef.cet, getcet, getcet.getNext());
                        this.addPara(outf);
                        getcet = getcet.getNext().getNextUseCET();
                        bef = null;
                    } else if (str.equals(",")) {
                        this.exeparas.add(bef);
                        bef = null;
                        getcet = getcet.getNext();
                    } else {
                        bef = new ParaPart(getcet);
                        getcet = getcet.getNext();
                    }
                } else {
                    bef = new ParaPart(getcet);
                    getcet = getcet.getNext();
                }
                line.setNextUseCET(getcet);
            }
            return retval;
        }

        private void paraChgpre(ElementOutput output) {
            this.erlexeparas = new ArrayList();
            for (ParaPart pp : this.exeparas) {
                this.erlexeparas.add(pp.paraChgpre(output));
            }
        }

        private String toErlang() {
            StringBuffer retval = new StringBuffer();
            Iterator<String> it = this.erlexeparas.iterator();
            boolean edited = false;
            while (it.hasNext()) {
                String erlp = it.next();
                if (edited && retval.charAt(retval.length() - 1) != '{' && !erlp.equals("}")) {
                    retval.append(",");
                }
                retval.append(erlp);
                edited = true;
            }
            return retval.toString();
        }

        private void collectMemobj(ArrayList<MemObject> output) {
            for (ParaPart pp : this.exeparas) {
                pp.collectMemobj(output);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParaPart
    implements Serializable {
        private static final long serialVersionUID = 201003050022000041L;
        private CtoErlangTrans cet;
        private ElementFunc efunc;

        private ParaPart(CtoErlangTrans in) {
            this.cet = in;
        }

        private ParaPart(ElementFunc in) {
            this.efunc = in;
        }

        private String paraChgpre(ElementOutput output) {
            if (this.efunc != null) {
                this.efunc.setExtflg(output);
                return this.efunc.toErlang(output);
            }
            MemObject mo = this.cet.getMemObj();
            if (mo != null) {
                if (output.isExtmem(mo.getMyKey())) {
                    return Element.getExtLoad_Erl(mo);
                }
                return mo.ctoErlnagVal(false);
            }
            if (this.cet.getElement() != null) {
                this.cet.getElement().setExtflg(output);
                return this.cet.getElement().toErlang(output);
            }
            return this.cet.getString();
        }

        private void collectMemobj(ArrayList<MemObject> output) {
            if (this.cet == null) {
                this.efunc.collectMemobj(output);
                return;
            }
            MemObject mo = this.cet.getMemObj();
            if (mo != null) {
                if (!output.contains(mo)) {
                    output.add(mo);
                }
            } else {
                Element ele = this.cet.getElement();
                if (ele != null) {
                    ele.collectMemobj(output);
                }
            }
        }
    }
}

