/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.erlang;

import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.MemObject;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementBasic;
import analyzecodeC.erlang.ElementFunc;
import analyzecodeC.erlang.ElementGuard;
import analyzecodeC.erlang.ElementLoop;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtoErlangTrans
implements Serializable {
    private static final long serialVersionUID = 201002060017000001L;
    private Element inele;
    private String str;
    private MemObject memobj;
    private CtoErlangTrans next = null;
    private CtoErlangTrans befor = null;
    private CtoErlangTrans nextUseCET;

    public CtoErlangTrans(String wordorconj) {
        this.str = wordorconj;
    }

    public CtoErlangTrans(MemObject struct) {
        this.memobj = struct;
    }

    public CtoErlangTrans(Element ele) {
        this.inele = ele;
    }

    public Element getElement() {
        return this.inele;
    }

    public String getString() {
        return this.str;
    }

    public MemObject getMemObj() {
        return this.memobj;
    }

    public void addnext(CtoErlangTrans cet) {
        CtoErlangTrans add = this.next;
        CtoErlangTrans bef = this;
        while (add != null) {
            bef = add;
            add = add.next;
        }
        bef.next = cet;
        cet.befor = bef;
    }

    public CtoErlangTrans getNext() {
        return this.next;
    }

    public CtoErlangTrans getLast() {
        CtoErlangTrans retval = null;
        CtoErlangTrans cet = this;
        while (cet != null) {
            retval = cet;
            cet = cet.next;
        }
        return retval;
    }

    public boolean isStructLine() {
        if (this.str != null) {
            return WordSystemRev.isStructTypeWord(this.str);
        }
        return false;
    }

    public boolean isLoopLine() {
        if (this.str != null) {
            return this.str.equals("for") || this.str.equals("while") || this.str.equals("do");
        }
        return false;
    }

    public Element thinkEle() {
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        Element retval = new Element();
        if (this.memobj != null) {
            retval.setEleA(this.memobj);
        } else {
            retval.setEleA(this.str);
        }
        this.nextUseCET = this.next;
        return retval;
    }

    public Element thinkLoop() {
        this.nextUseCET = this;
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        CtoErlangTrans a = this;
        if (a.getNext() == null) {
            return null;
        }
        CtoErlangTrans b = a.getNext();
        if (b.getNext() == null) {
            return null;
        }
        CtoErlangTrans para = b.getNext();
        ElementLoop el = ElementLoop.creElementFor(a, b, para);
        if (el != null) {
            this.nextUseCET = para.getNextUseCET();
            return el;
        }
        return null;
    }

    public ElementGuard thinkGuard() {
        this.nextUseCET = this;
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        CtoErlangTrans a = this;
        CtoErlangTrans b = a.getNext();
        if (b == null || b.getNext() == null) {
            ElementGuard el = ElementGuard.creElementElse(a);
            if (el != null) {
                this.nextUseCET = b;
                return el;
            }
            return null;
        }
        CtoErlangTrans para = b.getNext();
        ElementGuard el = ElementGuard.creElementIf(a, b, para);
        if (el != null) {
            this.nextUseCET = para.getNextUseCET();
            return el;
        }
        el = ElementGuard.creElementElse(a);
        if (el != null) {
            this.nextUseCET = this.getNext();
            return el;
        }
        return null;
    }

    public ElementBasic thinkBasicElement() {
        this.nextUseCET = this;
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        CtoErlangTrans work = this.befor == null ? this : this.befor;
        CtoErlangTrans a = work;
        if (a.getNext() == null) {
            return null;
        }
        CtoErlangTrans b = a.getNext();
        ElementBasic el = ElementBasic.creBasic(a, b);
        if (el != null) {
            this.nextUseCET = b.getNext();
            return el;
        }
        if (b.getNext() == null) {
            return null;
        }
        CtoErlangTrans c = b.getNext();
        el = ElementBasic.creBasic(a, b, c);
        if (el != null) {
            this.nextUseCET = c.getNext();
            return el;
        }
        return null;
    }

    public static Element repSetArray(Element el) {
        MemObject moA;
        if (el.isSetSent() && (moA = el.getEleAMemObj()) != null && moA.getArraygetidx() != null) {
            ElementFunc efunc = new ElementFunc(moA.getSetArrayValFunc(), moA.getSetArrayParaSize());
            efunc.addPara(new CtoErlangTrans(moA.getArraydat().getArrayKey()));
            efunc.addPara(new CtoErlangTrans("{"));
            efunc.addPara(new CtoErlangTrans(moA.getArrayIdxcalEl()));
            efunc.addPara(new CtoErlangTrans(el.getSetMethod()));
            efunc.addPara(new CtoErlangTrans("}"));
            ElementBasic retb = ElementBasic.ctoErlb(new CtoErlangTrans(el.getEleAMemObj()), el.getEleB_ToErlang(), efunc);
            return retb;
        }
        return el;
    }

    public ElementFunc thinkFuncElement() {
        this.nextUseCET = this;
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        CtoErlangTrans work = this.befor == null ? this : this.befor;
        CtoErlangTrans a = work;
        if (a.getNext() == null) {
            return null;
        }
        CtoErlangTrans b = a.getNext();
        if (b.getNext() == null) {
            return null;
        }
        ElementFunc el = ElementFunc.creElementFunc(a, b, b.getNext());
        if (el != null) {
            this.nextUseCET = b.getNext().getNextUseCET();
            return el;
        }
        return null;
    }

    public Element thinkEnd() {
        this.nextUseCET = this;
        if (this.inele != null) {
            throw new IllegalAccessError();
        }
        CtoErlangTrans work = this;
        if (work.getString() != null && work.getString().equals("return")) {
            CtoErlangTrans workb = work.getNext();
            if (workb == null) {
                this.nextUseCET = null;
                return null;
            }
            CtoErlangTrans workc = workb.getNext();
            if (workc != null && (workc.getString() != null && !workc.getString().equals("") || workc.getString() == null)) {
                workb.befor = null;
                this.nextUseCET = workb;
                return null;
            }
            Element retval = new Element();
            if (workb.getMemObj() != null) {
                retval.setEleA(workb.getMemObj());
            } else {
                retval.setEleA(workb.getString());
            }
            this.nextUseCET = workc;
            return retval;
        }
        this.nextUseCET = null;
        return null;
    }

    public CtoErlangTrans getNextUseCET() {
        return this.nextUseCET;
    }

    public void setNextUseCET(CtoErlangTrans incet) {
        this.nextUseCET = incet;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        if (this.memobj != null) {
            retval.append("[");
            retval.append(this.memobj.getName());
            retval.append("]");
        } else {
            retval.append(this.str);
        }
        return retval.toString();
    }

    public ArrayList<MemObject> getRefMemObj() {
        ArrayList<MemObject> retval = new ArrayList<MemObject>();
        CtoErlangTrans cet = this;
        while (cet != null) {
            String chkstr;
            MemObject mo = cet.getMemObj();
            if (mo == null) {
                cet = cet.getNext();
                continue;
            }
            String string = chkstr = (cet = cet.getNext()) != null ? cet.getString() : null;
            if (chkstr != null && chkstr.equals("=")) continue;
            ArrayList<MemObject> mos = mo.collectMemobj();
            retval.addAll(mos);
        }
        return retval;
    }

    public ElementBasic isSetSent() {
        CtoErlangTrans b = this.getNext();
        if (b == null) {
            return null;
        }
        ElementBasic eb = ElementBasic.creBasic(this, b);
        if (eb != null && eb.isSetSent()) {
            return eb;
        }
        CtoErlangTrans c = b.getNext();
        if (c == null) {
            return null;
        }
        eb = ElementBasic.creBasic(this, b, c);
        if (eb != null && eb.isSetSent()) {
            return eb;
        }
        return null;
    }
}

