/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.SentPart;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class StructtypeData
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060016000001L;
    private String name;
    private int state = 0;
    private transient StructtypeData useStruct = null;
    private MemObjects member;
    private static HashMap<String, StructtypeData> structtypes = new HashMap();

    public String getName() {
        return this.name;
    }

    public static StructtypeData forTestInstace() {
        StructtypeData retval = new StructtypeData();
        retval.member = MemObjects.forTestInstace();
        retval.name = "struct";
        return retval;
    }

    public boolean exeStateTrans(SentPart sp) {
        boolean retval = true;
        while (retval) {
            switch (this.state) {
                case 0: {
                    retval = this.state0(sp);
                    break;
                }
                case 1: {
                    retval = this.state1(sp);
                    break;
                }
                case 2: {
                    retval = this.state2(sp);
                    break;
                }
                case 3: {
                    retval = this.state3(sp);
                }
            }
        }
        return this.state != 0;
    }

    private boolean state0(SentPart sp) {
        this.useStruct = null;
        this.state = 1;
        return true;
    }

    private boolean state1(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            if (!sp.getWord().equals("struct")) {
                this.state = 0;
            }
            return false;
        }
        if (sp.getWord() == null || sp.getWord().equals("")) {
            this.state = 0;
            return false;
        }
        this.name = sp.getWord();
        this.state = 2;
        return true;
    }

    private boolean state2(SentPart sp) {
        if (WordSystemRev.isSysWord(sp)) {
            this.state = 0;
            return false;
        }
        String conj = sp.getConjunc();
        String word = sp.getWord();
        if (word != null && !word.equals("") && !word.equals(this.name)) {
            this.setNewInstance();
            this.state = 0;
            return false;
        }
        if (conj == null || conj.equals("") || conj.equals(" ")) {
            return false;
        }
        if (conj.equals("{")) {
            this.member = new MemObjects();
            this.state = 3;
        } else if (conj.equals(";")) {
            this.setNewInstance();
            this.state = 0;
        }
        return false;
    }

    private void setNewInstance() {
        this.useStruct = null;
        StructtypeData o = structtypes.get(this.name);
        if (o != null) {
            this.useStruct = o;
            try {
                this.useStruct = (StructtypeData)this.useStruct.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public StructtypeData getUseStruct() {
        return this.useStruct;
    }

    private boolean state3(SentPart sp) {
        this.member.exeStateTrans(sp);
        String conj = sp.getConjunc();
        if (conj != null && conj.equals("}")) {
            this.state = 0;
            try {
                StructtypeData out = (StructtypeData)this.clone();
                structtypes.put(this.name, out);
                this.member = null;
                this.name = null;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        StructtypeData retval = new StructtypeData();
        retval.name = this.name;
        retval.member = (MemObjects)this.member.clone();
        return retval;
    }

    public MemObjects getMember() {
        return this.member;
    }

    public static StructtypeData getStructtypes(String name) {
        StructtypeData o = structtypes.get(name);
        if (o == null || !(o instanceof StructtypeData)) {
            return null;
        }
        return o;
    }

    public MemObject getNewInstance(String areaname, int id) {
        MemObject retval = new MemObject(areaname, id, this);
        return retval;
    }

    public static String toErlnagRecodeAll() {
        StringBuffer retval = new StringBuffer();
        Collection<StructtypeData> vals = structtypes.values();
        for (StructtypeData st : vals) {
            retval.append(st.toErlnagRecode());
        }
        return retval.toString();
    }

    public String toErlnagRecode() {
        StringBuffer retval = new StringBuffer("-record(" + this.name + ",\n  {");
        Hashtable<String, MemObject> output = new Hashtable<String, MemObject>();
        this.member.getMemObjects(output);
        Enumeration<String> er = output.keys();
        while (er.hasMoreElements()) {
            String o = er.nextElement();
            MemObject mo = output.get(o);
            retval.append("  " + mo.getName());
            if (mo.getDefaultVal() != null) {
                retval.append("=" + mo.getDefaultVal());
            }
            if (!er.hasMoreElements()) continue;
            retval.append(",\n");
        }
        retval.append("}).\n\n");
        return retval.toString();
    }

    public String getDefKey() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.name);
        return retval.toString();
    }

    public String getDefValue() {
        StringBuffer retval = new StringBuffer();
        retval.append(0);
        return retval.toString();
    }
}

