/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.ProcessBlock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessRoute
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 201002060013000001L;
    private Route getrtnow = null;
    private RouteTick getnow = null;
    private Route toprt = null;
    private AnllingRouteChain anltop = null;
    private int nowaddnest = 0;

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean first() {
        this.getrtnow = this.toprt;
        return this.getrtnow != null;
    }

    public int getRouteSize() {
        int retval = 0;
        Route nrt = this.toprt;
        while (nrt != null) {
            ++retval;
            nrt = nrt.nextroute;
        }
        return retval;
    }

    public boolean hasNext() {
        return this.getrtnow != null;
    }

    public int next() {
        int retval = this.getrtnow.rtno;
        this.getrtnow = this.getrtnow.nextroute;
        return retval;
    }

    public ProcessBlock[] getRouteProBlocks(int getrtno) {
        ArrayList<ProcessBlock> out = new ArrayList<ProcessBlock>();
        Route chk = this.toprt;
        while (chk != null && chk.rtno != getrtno) {
            chk = chk.nextroute;
        }
        if (chk == null) {
            return new ProcessBlock[0];
        }
        RouteTick rt = chk.mytop;
        while (rt != null) {
            out.add(rt.tick);
            rt = rt.nextBlock;
        }
        ProcessBlock[] retval = new ProcessBlock[out.size()];
        out.toArray(retval);
        return retval;
    }

    public BasicBlock[] getRouteBsBlocks(int getrtno) {
        ProcessBlock[] pbs = this.getRouteProBlocks(getrtno);
        BasicBlock[] retval = new BasicBlock[pbs.length];
        for (int i = 0; i < pbs.length; ++i) {
            retval[i] = pbs[i].getBasicBlock();
        }
        return retval;
    }

    private Route getLast() {
        Route rt = this.toprt.nextroute;
        Route retval = this.toprt;
        while (rt != null) {
            retval = rt;
            rt = rt.nextroute;
        }
        return retval;
    }

    private void AnlingChainAttach(AnllingRouteChain atarq) {
        if (this.anltop == null) {
            this.anltop = atarq;
            this.anltop.befor = null;
            this.anltop.next = null;
            return;
        }
        this.anltop.befor = atarq;
        atarq.next = this.anltop;
        atarq.befor = null;
        this.anltop = atarq;
    }

    private AnllingRouteChain addRoute(AnllingRouteChain atarq, int offset) {
        Route rt = atarq.route.copyRoute(offset);
        rt.addRoute();
        RouteTick tick = rt.mytop.getLastBlock();
        AnllingRouteChain arq = new AnllingRouteChain(tick, atarq.nest);
        arq.route = rt;
        rt.arc = arq;
        return arq;
    }

    private ArrayList<AnllingRouteChain> addRoute(Iterator<AnllingRouteChain> arcs, int offset) {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        while (arcs.hasNext()) {
            AnllingRouteChain arc = arcs.next();
            AnllingRouteChain add = this.addRoute(arc, offset);
            retval.add(add);
        }
        return retval;
    }

    public void startAnl(ProcessBlock pb) {
        if (this.anltop != null) {
            return;
        }
        RouteTick frt = new RouteTick(pb);
        this.anltop = new AnllingRouteChain(frt, pb.getNest());
        this.toprt = new Route(frt);
        this.toprt.cplist.add(this.toprt.rtno);
        this.anltop.route = this.toprt;
        this.toprt.arc = this.anltop;
        this.nowaddnest = pb.getNest();
    }

    public void addBlock(ProcessBlock bt) {
        if (this.anltop == null) {
            this.startAnl(bt);
            return;
        }
        int nest = bt.getNest();
        if (this.nowaddnest < nest) {
            this.nowaddnest = nest;
            this.addBlock(bt, this.getNowAnlBlocks().iterator());
        } else if (this.nowaddnest == nest) {
            this.nowaddnest = nest;
            ArrayList<AnllingRouteChain> out = this.getNowAnlBlocks();
            ArrayList<AnllingRouteChain> out2 = this.getNowAnlEqBlocks(out.iterator(), nest - 1, true);
            if (out2.isEmpty()) {
                out2 = this.addRoute(out.iterator(), 1);
            }
            this.addBlock(bt, out2.iterator());
        } else {
            this.nowaddnest = nest;
            this.addBlock(bt, this.getNowAnlEqBlocks(this.getNowAnlBlocks().iterator(), nest, false).iterator());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessRoute other = (ProcessRoute)obj;
        if (!(this.getrtnow == other.getrtnow || this.getrtnow != null && this.getrtnow.equals(other.getrtnow))) {
            return false;
        }
        if (!(this.getnow == other.getnow || this.getnow != null && this.getnow.equals(other.getnow))) {
            return false;
        }
        if (!(this.toprt == other.toprt || this.toprt != null && this.toprt.equals(other.toprt))) {
            return false;
        }
        if (!(this.anltop == other.anltop || this.anltop != null && this.anltop.equals(other.anltop))) {
            return false;
        }
        return this.nowaddnest == other.nowaddnest;
    }

    private ArrayList<AnllingRouteChain> getNowAnlBlocks() {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        AnllingRouteChain arc = this.anltop;
        while (arc != null) {
            retval.add(arc);
            arc = arc.next;
        }
        return retval;
    }

    private ArrayList<AnllingRouteChain> getNowAnlEqBlocks(Iterator<AnllingRouteChain> arcs, int nest, boolean chknest) {
        ArrayList<AnllingRouteChain> retval = new ArrayList<AnllingRouteChain>();
        while (arcs.hasNext()) {
            AnllingRouteChain arc = arcs.next();
            Route now = arc.route;
            Route sr = this.toprt;
            while (sr != null) {
                if (now.eqRouteType(nest, sr)) {
                    if (chknest) {
                        if (sr.arc.nest == nest) {
                            retval.add(sr.arc);
                        }
                    } else {
                        retval.add(sr.arc);
                    }
                }
                sr = sr.nextroute;
            }
        }
        return retval;
    }

    private void addBlock(ProcessBlock pb, Iterator<AnllingRouteChain> arcs) {
        this.anltop = null;
        while (arcs.hasNext()) {
            AnllingRouteChain arc = arcs.next();
            RouteTick rt = arc.anlling.addBlockLink(pb);
            arc.modAnlling(rt, this.nowaddnest);
            this.AnlingChainAttach(arc);
        }
    }

    private class AnllingRouteChain
    implements Serializable {
        private RouteTick anlling = null;
        private static final long serialVersionUID = 201003050013000005L;
        private AnllingRouteChain next = null;
        private AnllingRouteChain befor = null;
        private int nest = 0;
        private Route route = null;

        private AnllingRouteChain(RouteTick my, int waitnest) {
            this.anlling = my;
            this.nest = waitnest;
        }

        private void modAnlling(RouteTick my, int newnest) {
            this.anlling = my;
            this.nest = newnest;
        }
    }

    private class RouteTick
    implements Serializable {
        private static final long serialVersionUID = 201003050013000016L;
        private ProcessBlock tick;
        private RouteTick beforBlock;
        private RouteTick nextBlock;

        private RouteTick(ProcessBlock pb) {
            this.tick = pb;
        }

        private RouteTick getLastBlock() {
            RouteTick rt = this.nextBlock;
            RouteTick retval = this;
            while (rt != null) {
                retval = rt;
                rt = rt.nextBlock;
            }
            return retval;
        }

        private RouteTick addBlockLink(ProcessBlock pb) {
            this.nextBlock = new RouteTick(pb);
            this.nextBlock.beforBlock = this;
            return this.nextBlock;
        }
    }

    private class Route
    implements Serializable {
        private static final long serialVersionUID = 201003050013000017L;
        private int rtno = 1;
        private RouteTick mytop = null;
        private Route nextroute = null;
        private AnllingRouteChain arc = null;
        private MyUtil.PrimitiveArrayI cplist = new MyUtil.PrimitiveArrayI();

        private Route(RouteTick rt) {
            this.mytop = rt;
        }

        private Route(RouteTick rt, int routeno) {
            this(rt);
            this.rtno = routeno;
        }

        private boolean eqRouteType(int chknest, Route cmp) {
            if (chknest >= this.cplist.size() || chknest >= cmp.cplist.size()) {
                return false;
            }
            for (int i = 0; i <= chknest; ++i) {
                if (this.cplist.getValue(i) == cmp.cplist.getValue(i)) continue;
                return false;
            }
            return true;
        }

        private void addRoute() {
            ((ProcessRoute)ProcessRoute.this).getLast().nextroute = this;
        }

        private Route copyRoute(int offset) {
            RouteTick cprt = new RouteTick(this.mytop.tick);
            int rtnonew = ((ProcessRoute)ProcessRoute.this).getLast().rtno + 1;
            Route retval = new Route(cprt, rtnonew);
            retval.cplist.addAll(this.cplist);
            retval.cplist.add(rtnonew);
            RouteTick rt = this.mytop;
            int count = 0;
            while (rt != null) {
                ++count;
                rt = rt.nextBlock;
            }
            rt = this.mytop.nextBlock;
            int roop = 1;
            while (rt != null && count - roop > offset) {
                cprt.addBlockLink(rt.tick);
                rt = rt.nextBlock;
                ++roop;
            }
            return retval;
        }
    }
}

