/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.SentPart;
import analyzecodeC.WRwSplitChars;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.BasicBlock;
import analyzecodeC.decode.BlockType;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemToProBlTrans;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.StructBlock;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementBasic;
import analyzecodeC.erlang.ElementLoop;
import analyzecodeC.erlang.Guardtype;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ProcessBlock
implements BlockType,
Comparable,
Serializable {
    private static final long serialVersionUID = 201002060002000001L;
    private ProcessKakko pk;
    private int state = 0;
    private int subnest = 0;
    private int nest = 0;
    private boolean retind = true;
    private ArrayList<OneLine> block = new ArrayList();
    private OneLine line = new OneLine();
    private int blockno = -1;
    private String endword = null;
    private String endconj = null;

    public ProcessBlock(ProcessKakko prokakko) {
        this.pk = prokakko;
    }

    public ProcessBlock(int nest, ProcessKakko prokakko) {
        this.nest = nest;
        this.pk = prokakko;
    }

    public ProcessKakko getPk() {
        return this.pk;
    }

    public int getNest() {
        return this.nest;
    }

    public int getBlockno() {
        return this.blockno;
    }

    public void setBlockno(int no) {
        this.blockno = no;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ProcessBlock)) {
            throw new ClassCastException();
        }
        ProcessBlock pb = (ProcessBlock)o;
        if (this.getBlockno() == pb.getBlockno()) {
            return 0;
        }
        if (this.getBlockno() > pb.getBlockno()) {
            return 1;
        }
        return -1;
    }

    public boolean isLoop() {
        if (this.block.isEmpty()) {
            return false;
        }
        return this.block.get(0).getTop().isLoop();
    }

    public boolean isCondition() {
        if (this.block.isEmpty()) {
            if (this.line != null && this.line.getTop() != null) {
                return this.line.getTop().isCondition();
            }
            return false;
        }
        return this.block.get(0).getTop().isCondition();
    }

    public CtoErlangTrans[] getLines() {
        CtoErlangTrans[] retval = new CtoErlangTrans[this.block.size()];
        int cnt = 0;
        for (OneLine ol : this.block) {
            retval[cnt++] = ol.getLine();
        }
        return retval;
    }

    public BasicBlock getBasicBlock() {
        if (this.block.isEmpty()) {
            return null;
        }
        BasicBlock retval = new BasicBlock();
        Iterator<OneLine> it = this.block.iterator();
        while (it.hasNext()) {
            OneLine ol = it.next();
            if (!ol.getTop().isCondition()) {
                Element el = Element.newInstanceBase(ol.getLine());
                if (el == null) continue;
                retval.addLine(el);
                continue;
            }
            if (!ol.getTop().isLoop()) continue;
            CtoErlangTrans cet = ol.getLine();
            int offset = ElementLoop.getBBtopOffset(cet);
            for (int i = 1; i < offset; ++i) {
                it.next();
            }
        }
        return retval;
    }

    public StructBlock getStructBlock(StructBlock retval, int funcrtval) {
        Element bef = null;
        for (OneLine ol : this.block) {
            Element el;
            if (!ol.getTop().isCondition() || (el = Element.newInstanceGuard(ol.getLine())) == null) continue;
            if (bef instanceof Guardtype) {
                ((Guardtype)((Object)bef)).setExpress(el);
            }
            bef = el;
            retval.addLine(el);
        }
        Element ret = new Element();
        ret.setEleA(new Integer(funcrtval).toString());
        if (bef instanceof Guardtype) {
            ((Guardtype)((Object)bef)).setExpress(ret);
        }
        return retval;
    }

    public InputMemnames getInput(boolean struct) {
        InputMemnames retval = new InputMemnames();
        this.getInput(retval, struct);
        return retval;
    }

    public void getInput(InputMemnames retval, boolean struct) {
        for (OneLine ol : this.block) {
            if (!ol.getTop().isCondition() && struct || ol.getTop().isCondition() && !struct) continue;
            CtoErlangTrans cet = ol.getLine();
            retval.creInput(cet, this.pk);
        }
    }

    public ProcessBlock exeStateTrans(MemToProBlTrans mtob) {
        ProcessBlock retval = null;
        MemToProBlTrans exmtpb = mtob;
        while (exmtpb != null) {
            if (exmtpb.isEmpty()) {
                exmtpb = exmtpb.getNext();
                continue;
            }
            this.retind = false;
            while (!this.retind) {
                this.retind = true;
                switch (this.state) {
                    case 0: {
                        retval = this.state0(exmtpb);
                        break;
                    }
                    case 1: {
                        retval = this.state1(exmtpb);
                        break;
                    }
                    case 2: {
                        retval = this.state2(exmtpb);
                        break;
                    }
                    case 3: {
                        retval = this.state3(exmtpb);
                        break;
                    }
                    case 4: {
                        retval = this.state4(exmtpb);
                        break;
                    }
                    case 10: {
                        retval = this.state10(exmtpb);
                        break;
                    }
                    case 100: {
                        retval = this.state100(exmtpb);
                        break;
                    }
                    default: {
                        throw new IllegalAccessError();
                    }
                }
                if (retval == null) continue;
                return retval;
            }
            exmtpb = exmtpb.getNext();
        }
        return null;
    }

    private ProcessBlock state0(MemToProBlTrans mtob) {
        this.retind = false;
        this.state = 1;
        switch (mtob.getWordDatatype()) {
            case 1: {
                this.line.addLine(mtob.getMemObj());
                return null;
            }
            case 0: {
                return null;
            }
            case 2: {
                this.retind = true;
                this.state = 2;
                return null;
            }
            case 3: {
                return null;
            }
            case 4: {
                this.endword = null;
                this.endconj = "}";
                this.state = 100;
                return null;
            }
            case 5: {
                this.state = 0;
                return this.newBlock(mtob);
            }
        }
        this.line.addLine(mtob.getSentPart().getWord());
        return null;
    }

    private ProcessBlock newBlock(MemToProBlTrans mtob) {
        ProcessBlock retval = new ProcessBlock(this.nest - this.subnest, this.pk);
        retval.line.addLine(mtob.getSentPart().getWord());
        retval.state1(mtob);
        return retval;
    }

    private ProcessBlock newBlock2(MemToProBlTrans mtob) {
        ProcessBlock retval = new ProcessBlock(this.nest - this.subnest, this.pk);
        ProcessBlock out = retval.exeStateTrans(mtob);
        if (out != null) {
            throw new IllegalAccessError();
        }
        return retval;
    }

    private ProcessBlock state1(MemToProBlTrans mtob) {
        this.state = 0;
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent()) {
            return null;
        }
        if (conj.equals("{") && this.isCondition()) {
            ++this.nest;
        } else if (this.nest > 0 && conj.equals("}")) {
            ++this.subnest;
            this.state = 10;
        }
        if (mtob.isEndofLine()) {
            if (this.line.isEmpty()) {
                return null;
            }
            this.block.add(this.line);
            this.line = new OneLine();
            return null;
        }
        if (conj.equals(".")) {
            this.line.modAddLine(conj);
        } else {
            this.line.addLine(conj);
        }
        return null;
    }

    private ProcessBlock state2(MemToProBlTrans mtob) {
        switch (mtob.getWordDatatype()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.state = 0;
                return null;
            }
        }
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent() || conj.equals("\n")) {
            this.state = 3;
            return null;
        }
        if (WRwSplitChars.isSettoMark(conj)) {
            this.retind = false;
            this.state = 0;
            return null;
        }
        if (WRwSplitChars.isKakkoStart(conj)) {
            if (!conj.equals("(")) {
                throw new IllegalAccessError();
            }
        } else {
            this.retind = false;
            this.state = 0;
            return null;
        }
        this.endconj = ")";
        this.endword = null;
        this.state = 100;
        return null;
    }

    private ProcessBlock state3(MemToProBlTrans mtob) {
        if (mtob.isMemObject()) {
            throw new IllegalArgumentException();
        }
        String conj = mtob.getConj();
        if (!mtob.isConjHasContent() || conj.equals("\n")) {
            this.state = 3;
            return null;
        }
        if (WRwSplitChars.isSettoMark(conj)) {
            this.retind = false;
            this.state = 0;
            return null;
        }
        if (WRwSplitChars.isKakkoStart(conj)) {
            if (!conj.equals("(")) {
                throw new IllegalAccessError();
            }
        } else {
            this.retind = false;
            this.state = 0;
            return null;
        }
        this.endconj = ")";
        this.endword = null;
        this.state = 100;
        return null;
    }

    private ProcessBlock state4(MemToProBlTrans mtob) {
        throw new Error();
    }

    private ProcessBlock state10(MemToProBlTrans mtob) {
        this.retind = false;
        this.state = 1;
        switch (mtob.getWordDatatype()) {
            case 1: {
                return this.newBlock2(mtob);
            }
            case 0: {
                return null;
            }
            case 5: {
                this.state = 0;
                return this.newBlock(mtob);
            }
        }
        return this.newBlock2(mtob);
    }

    private ProcessBlock state100(MemToProBlTrans mtob) {
        if (mtob.isMemObject()) {
            return null;
        }
        SentPart sp = mtob.getSentPart();
        if (sp.contain(this.endword, this.endconj)) {
            this.state = 0;
            this.endword = null;
            this.endconj = null;
        }
        return null;
    }

    public String toLog() {
        StringBuffer retval = new StringBuffer();
        retval.append("blockno=" + this.blockno + "  nest=" + this.nest + "  -nest=" + this.subnest + "  state=" + this.state + "\n");
        for (OneLine ol : this.block) {
            retval.append(ol.toLog());
        }
        retval.append("\n");
        return retval.toString();
    }

    public boolean chkSMP() {
        ArrayList<MemObject> allrefmo = new ArrayList<MemObject>();
        ArrayList<MemObject> allsetmo = new ArrayList<MemObject>();
        Iterator<OneLine> it = this.block.iterator();
        while (it.hasNext()) {
            ArrayList<MemObject> mos;
            OneLine ol = it.next();
            CtoErlangTrans cet = ol.getLine();
            int offset = ElementLoop.getBBtopOffset(cet);
            for (int i = 1; i < offset; ++i) {
                it.next();
            }
            if (offset > 0) continue;
            ElementBasic eb = cet.isSetSent();
            if (eb != null) {
                if (!allsetmo.contains(cet.getMemObj())) {
                    allsetmo.add(cet.getMemObj());
                }
                eb.setEleA("");
                mos = eb.collectMemobj();
                allrefmo.addAll(mos);
                cet = cet.getNext();
            }
            mos = cet.getRefMemObj();
            allrefmo.addAll(mos);
        }
        Iterator itm = allsetmo.iterator();
        while (itm.hasNext()) {
            if (!allrefmo.contains(itm.next())) continue;
            return false;
        }
        return this.isLoop();
    }

    private class OneLine
    implements Serializable {
        private static final long serialVersionUID = 201003050002000003L;
        private ArrayList<OneTick> line = new ArrayList();

        private OneLine() {
        }

        private void addLine(String addstr) {
            this.line.add(new OneTick(addstr));
        }

        private void addLine(MemObject addstr) {
            this.line.add(new OneTick(addstr));
        }

        private void modAddLine(String modstr) {
            OneTick ot = this.getLast();
            if (ot.mobj == null) {
                throw new Error();
            }
            ot.tick = ot.tick + modstr;
        }

        private OneTick getTop() {
            if (this.line.isEmpty()) {
                return null;
            }
            return this.line.get(0);
        }

        private boolean isEmpty() {
            return this.line.isEmpty();
        }

        private OneTick getLast() {
            return this.line.get(this.line.size() - 1);
        }

        private CtoErlangTrans getLine() {
            CtoErlangTrans top = null;
            for (OneTick ot : this.line) {
                if (top == null) {
                    top = ot.getCET();
                    continue;
                }
                top.addnext(ot.getCET());
            }
            return top;
        }

        private String toLog() {
            StringBuffer retval = new StringBuffer();
            retval.append("  Line=");
            for (OneTick ot : this.line) {
                retval.append(ot.toLog());
            }
            retval.append("\n");
            return retval.toString();
        }
    }

    private class OneTick
    implements Serializable {
        private static final long serialVersionUID = 201003050002000004L;
        private String tick;
        private MemObject mobj;

        private OneTick(String onetick) {
            this.tick = onetick;
        }

        private OneTick(MemObject onetick) {
            this.mobj = onetick;
        }

        private boolean isCondition() {
            if (this.mobj != null) {
                return false;
            }
            return WordSystemRev.isStructTypeWord(this.tick);
        }

        private boolean isLoop() {
            return this.getCET().isLoopLine();
        }

        private CtoErlangTrans getCET() {
            if (this.mobj != null) {
                return new CtoErlangTrans(this.mobj);
            }
            return new CtoErlangTrans(this.tick);
        }

        public String toLog() {
            StringBuffer retval = new StringBuffer();
            if (this.tick != null) {
                retval.append(this.tick);
            } else {
                retval.append("[");
                retval.append(this.mobj.getName());
                retval.append("]");
            }
            retval.append(" ");
            return retval.toString();
        }
    }
}

