/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.SentPart;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.MemObject;
import java.io.Serializable;

public class MemToProBlTrans
implements Serializable {
    private static final long serialVersionUID = 201002060012000001L;
    private MemToProBlTrans next;
    private MemObject mo;
    private String conj = "";
    private SentPart sp;
    public static final int NODATA = 0;
    public static final int MEMOBJ = 1;
    public static final int PRIMTYPEWORD = 2;
    public static final int TYPEDEF = 3;
    public static final int UNION = 4;
    public static final int STRUCTTYPE = 5;
    public static final int OTHER = 6;

    public MemToProBlTrans(MemObject inmo, String conj) {
        this.mo = inmo;
        this.conj = conj;
    }

    public MemToProBlTrans(SentPart insp) {
        this.sp = insp;
        this.conj = this.sp.getConjunc();
    }

    public MemToProBlTrans() {
    }

    public void setNextMTPB(String word, String conj) {
        this.next = new MemToProBlTrans(new SentPart(word, conj));
    }

    public MemToProBlTrans getNext() {
        return this.next;
    }

    public boolean isEmpty() {
        return this.mo == null && this.sp == null;
    }

    public boolean isMemObject() {
        return this.mo != null;
    }

    public MemObject getMemObj() {
        return this.mo;
    }

    public String getConj() {
        return this.conj;
    }

    public SentPart getSentPart() {
        return this.sp;
    }

    public void setMemToProBlTrans(SentPart insp) {
        this.mo = null;
        this.sp = insp;
        this.conj = insp.getConjunc();
    }

    public void setMemToProBlTrans(MemObject inmo, String conj) {
        this.mo = inmo;
        this.conj = conj;
        this.sp = null;
    }

    private void clear() {
        this.mo = null;
        this.sp = null;
        this.next = null;
        this.conj = null;
    }

    public MemToProBlTrans getRetVal(MemObject retmo, SentPart retsp) {
        if (this.mo != null) {
            MemToProBlTrans retval = new MemToProBlTrans(this.mo, this.conj);
            retval.next = this.next;
            this.clear();
            return retval;
        }
        if (this.sp != null) {
            MemToProBlTrans retval = new MemToProBlTrans(this.sp);
            retval.next = this.next;
            this.clear();
            return retval;
        }
        if (retmo != null) {
            MemToProBlTrans retval = new MemToProBlTrans();
            retval.next = this.next;
            return retval;
        }
        MemToProBlTrans retval = new MemToProBlTrans(retsp);
        retval.next = this.next;
        return retval;
    }

    public boolean isWordHasContent() {
        if (this.sp == null) {
            return false;
        }
        String word = this.sp.getWord();
        return word != null && !word.equals("") && !word.equals(" ");
    }

    public boolean isConjHasContent() {
        return this.conj != null && !this.conj.equals("") && !this.conj.equals(" ");
    }

    public boolean isEndofLine() {
        if (!this.isConjHasContent()) {
            return false;
        }
        return this.conj.equals(";") || this.conj.equals("{") || this.conj.equals(":") || this.conj.equals("}");
    }

    public boolean isSemiCEndofLine() {
        if (!this.isConjHasContent()) {
            return false;
        }
        return this.conj.equals(";");
    }

    public int getWordDatatype() {
        if (this.isMemObject()) {
            return 1;
        }
        if (!this.isSemiCEndofLine() && !this.isWordHasContent()) {
            return 0;
        }
        if (WordSystemRev.isSysWord(this.sp)) {
            if (WordSystemRev.isPrimTypeWord(this.sp)) {
                return 2;
            }
            if (WordSystemRev.isTyeDef(this.sp)) {
                return 3;
            }
            if (WordSystemRev.isUnionStruct(this.sp)) {
                return 4;
            }
            if (WordSystemRev.isStructTypeWord(this.sp)) {
                return 5;
            }
            return 6;
        }
        return 6;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemToProBlTrans other = (MemToProBlTrans)obj;
        if (!(this.mo == other.mo || this.mo != null && this.mo.equals(other.mo))) {
            return false;
        }
        if (this.conj == null ? other.conj != null : !this.conj.equals(other.conj)) {
            return false;
        }
        return this.sp == other.sp || this.sp != null && this.sp.equals(other.sp);
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + (this.mo != null ? this.mo.hashCode() : 0);
        hash = 13 * hash + (this.conj != null ? this.conj.hashCode() : 0);
        hash = 13 * hash + (this.sp != null ? this.sp.hashCode() : 0);
        return hash;
    }
}

