/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.MyUtil;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.MemObjects;
import java.io.Serializable;

public class MemObjArray
implements Serializable {
    private static final long serialVersionUID = 201002060009000001L;
    private String name = "";
    private String arrayKey;
    private MyUtil.PrimitiveArrayI arraynest = new MyUtil.PrimitiveArrayI();
    private Defaultval toparray = new Defaultval();

    public MemObjArray() {
    }

    protected MemObjArray(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getArrayKey() {
        return this.arrayKey;
    }

    public void setArrayKey(String arrayKey) {
        this.arrayKey = arrayKey;
    }

    public int getSizeElements() {
        int size = 1;
        this.arraynest.first();
        while (this.arraynest.hasNext()) {
            size *= this.arraynest.next();
        }
        return size;
    }

    public MyUtil.PrimitiveArrayI getArrayNest() {
        return this.arraynest;
    }

    protected void addNest(int size) {
        int nownest = this.arraynest.size();
        Defaultval dfv = this.getDfv(new int[nownest]);
        if (dfv == null) {
            this.toparray.setSize(size);
        } else {
            dfv.addChild(size);
        }
        this.arraynest.add(size);
    }

    public static String getArraySymName(String word) {
        StringBuffer synm = new StringBuffer();
        char[] cas = word.toCharArray();
        for (int index = 0; index < cas.length; ++index) {
            if (cas[index] == '[') {
                return synm.toString();
            }
            synm.append(cas[index]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MyUtil.ArrayObject getArrayIdx(MemObjects mobjs, String word) {
        MyUtil.ArrayObject retval = new MyUtil.ArrayObject();
        char[] cas = word.toCharArray();
        int start = -1;
        for (int index = 0; index < cas.length; ++index) {
            if (cas[index] == '[' && start < 0) {
                start = index + 1;
                continue;
            }
            if (cas[index] != ']') continue;
            Object outidx = MemObjArray.cntArraySize(cas, start, index);
            if (outidx == null) {
                return null;
            }
            if (outidx instanceof Integer) {
                retval.add(outidx.toString());
            } else {
                if (!(outidx instanceof String)) return null;
                MemObject mem = mobjs.getMemObjectFromAll(outidx.toString());
                if (mem == null) return null;
                retval.add(mem);
            }
            start = -1;
        }
        return retval;
    }

    public static MemObjArray instance(String word) {
        StringBuffer synm = new StringBuffer();
        MemObjArray retval = null;
        char[] cas = word.toCharArray();
        int start = -1;
        for (int index = 0; index < cas.length; ++index) {
            if (cas[index] == '[') {
                if (synm.length() == 0) {
                    return null;
                }
                start = index + 1;
                continue;
            }
            if (cas[index] == ']') {
                Object outidx;
                if (retval == null) {
                    retval = new MemObjArray();
                }
                if ((outidx = MemObjArray.cntArraySize(cas, start, index)) == null) {
                    return null;
                }
                if (!(outidx instanceof Integer)) {
                    return null;
                }
                retval.addNest((Integer)outidx);
                if (index + 1 == cas.length || cas[index + 1] != '[') break;
                start = 0;
                continue;
            }
            if (start >= 0) continue;
            synm.append(cas[index]);
        }
        if (retval != null) {
            retval.name = synm.toString();
        }
        return retval;
    }

    private static Object cntArraySize(char[] cas, int start, int end) {
        boolean hex = false;
        boolean dec = false;
        int idx = start;
        if (!hex && cas[idx] == '0' && cas[idx + 1] == 'x') {
            idx += 2;
            hex = true;
        } else if (!dec && cas[idx] >= '0' && cas[idx] <= '9') {
            dec = true;
        }
        StringBuffer num = new StringBuffer();
        while (idx < end) {
            if (dec) {
                if (cas[idx] < '0' || cas[idx] > '9') break;
                num.append(cas[idx]);
            } else if (hex) {
                if ((cas[idx] < '0' || cas[idx] > '9') && (cas[idx] < 'a' || cas[idx] > 'f')) break;
                num.append(cas[idx]);
            } else {
                num.append(cas[idx]);
            }
            ++idx;
        }
        if (num.length() == 0) {
            return null;
        }
        if (dec || hex) {
            int radix = hex ? 16 : 10;
            int size = Integer.parseInt(num.toString(), radix);
            return new Integer(size);
        }
        return num.toString();
    }

    public boolean setdefault(int[] idx, String val) {
        if (idx == null) {
            return false;
        }
        Defaultval setdfv = this.getDfv(idx);
        if (setdfv == null || setdfv.child != null) {
            return false;
        }
        setdfv.val = val;
        return true;
    }

    private Defaultval getDfv(int[] idx) {
        Defaultval retval = null;
        int srnest = 0;
        Defaultval loop = this.toparray;
        while (loop != null && srnest < idx.length) {
            int currentidx = idx[srnest++];
            for (int i = 0; i < currentidx; ++i) {
                loop = loop.nextidx;
            }
            if (loop == null) {
                return null;
            }
            retval = loop;
            loop = loop.child;
        }
        return retval;
    }

    public String getInitval() {
        if (this.toparray == null) {
            return null;
        }
        return this.toparray.toErlang();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemObjArray)) {
            return false;
        }
        MemObjArray in = (MemObjArray)obj;
        if (!this.name.equals(in.name)) {
            return false;
        }
        return this.arraynest.equals(in.arraynest);
    }

    private class Defaultval
    implements Serializable {
        private int noof = 0;
        private static final long serialVersionUID = 201003050009000002L;
        private String val;
        private Defaultval child;
        private Defaultval nextidx;

        private Defaultval() {
        }

        private Defaultval(String defval) {
            this.val = defval;
        }

        private void setSize(int size) {
            if (this.noof != 0) {
                return;
            }
            Defaultval setdfv = this;
            this.noof = size;
            for (int i = 0; i < this.noof; ++i) {
                setdfv.nextidx = new Defaultval();
            }
        }

        private void addChild(int size) {
            Defaultval setdfv = this;
            while (setdfv != null) {
                setdfv.child = new Defaultval();
                setdfv.child.setSize(size);
                setdfv = setdfv.nextidx;
            }
        }

        private String toErlang() {
            boolean edit = false;
            StringBuffer retval = new StringBuffer();
            retval.append("[");
            Defaultval setdfv = this;
            while (setdfv != null) {
                String out = null;
                out = setdfv.child != null ? setdfv.child.toErlang() : setdfv.val;
                if (out == null) {
                    setdfv = setdfv.nextidx;
                    continue;
                }
                if (edit) {
                    retval.append(",");
                }
                edit = true;
                retval.append(out);
                setdfv = setdfv.nextidx;
            }
            retval.append("]");
            if (edit) {
                return retval.toString();
            }
            return null;
        }
    }
}

