/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC.decode;

import analyzecodeC.decode.BlockType;
import analyzecodeC.decode.MemObject;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.erlang.CtoErlangTrans;
import analyzecodeC.erlang.EditBuffer;
import analyzecodeC.erlang.Element;
import analyzecodeC.erlang.ElementLoop;
import analyzecodeC.erlang.ElementOutput;
import analyzecodeC.erlang.ErlangCreator;
import analyzecodeC.erlang.InputMemnames;
import java.io.Serializable;

public class LoopBlock
implements BlockType,
Serializable {
    private InputMemnames input = new InputMemnames();
    private static final long serialVersionUID = 201002060008000001L;
    private InputMemnames bbinput;
    private Element start;
    private Element stop;
    private InputMemnames stopin;
    private Element incle;

    public InputMemnames getInput() {
        return this.input;
    }

    public void addBBinput(InputMemnames bbinput) {
        this.input.putInput(bbinput);
        if (this.bbinput == null) {
            this.bbinput = bbinput;
        } else {
            this.bbinput.putInput(bbinput);
        }
    }

    public boolean getCallFuncBody(String fname, ElementOutput output, EditBuffer retval, boolean smp) {
        output.updateRamdParaVal(((ElementLoop)this.start).getStartElement());
        String inpara = this.input.toErlang(output);
        if (smp) {
            ErlangCreator.getLoopFuncCallLineSMP(fname, "{" + inpara + "}", retval);
        } else {
            this.input.updateParaname(output);
            String rettaple = this.getRetTaple(output);
            ErlangCreator.getLoopFuncCallLine(fname, "{" + inpara + "}", rettaple, retval);
        }
        return true;
    }

    public boolean getFuncBodyTop(String funcname, ElementOutput output, EditBuffer retval) {
        this.start.setExtflg(output);
        this.stop.setExtflg(output);
        this.incle.setExtflg(output);
        ErlangCreator.getFuncTopLoop(funcname, "Input", this.input.getTaple(output), this.stop.toErlang(output), retval);
        return true;
    }

    public InputMemnames getBBInput() {
        return this.bbinput;
    }

    public boolean getFuncBodyEnd(String funcname, ElementOutput output, EditBuffer retval, boolean smp) {
        output.updateRamdParaVal(this.incle);
        ErlangCreator.getFunLoopRecus(funcname, this.input.getTapleRamda(output), retval);
        if (smp) {
            ErlangCreator.getFuncEndLoop_SMP(funcname, this.input.getTaple(output), this.bbinput.getTaple(output), retval);
            ErlangCreator.getFuncSMP_Recfunc(funcname, this.stop.toErlang(), retval);
        } else {
            ErlangCreator.getFuncEndLoop(funcname, this.input.getTaple(output), this.bbinput.getTaple(output), retval);
        }
        return true;
    }

    public String getRetTaple(ElementOutput output) {
        StringBuffer retval = new StringBuffer();
        retval.append("{");
        String[] paras = this.bbinput.getparas();
        paras = output.getPk().getInmems().sortRamdaparaNames(paras);
        int outset = 0;
        for (int i = 0; i < paras.length; ++i) {
            MemObject mo = output.getPk().getInmems().getMemObject(paras[i]);
            if (mo != null && mo.getArraydat() != null) continue;
            if (outset != 0) {
                retval.append(",");
            }
            retval.append(output.getNowRamdParaName(paras[i]));
            ++outset;
        }
        retval.append("}");
        return retval.toString();
    }

    public static LoopBlock getLoopBlock(CtoErlangTrans[] lines, ProcessKakko pk) {
        if (lines == null || lines.length == 0 || !lines[0].isLoopLine()) {
            return null;
        }
        LoopBlock retval = new LoopBlock();
        retval.start = Element.newInstanceLoop(lines[0]);
        retval.input.creInput(lines[0], pk);
        if (retval.start instanceof ElementLoop) {
            retval.stop = Element.newInstanceBase(lines[1]);
            retval.stopin = new InputMemnames();
            retval.stopin.creInput(lines[1], pk);
            retval.incle = Element.newInstanceBase(lines[2]);
            retval.input.creInput(lines[2], pk);
            retval.stopin = InputMemnames.reduce(retval.stopin, retval.input);
            retval.input.creInput(lines[1], pk);
        }
        return retval;
    }
}

