/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSystemRev {
    private static final String[] C_SYSWORD = new String[]{"auto", "double", "int", "struct", "break", "else", "long", "switch", "case", "enum", "register", "typedef", "char", "extern", "return", "union", "const", "float", "short", "unsigned", "continue", "for", "signed", "void", "default", "goto", "sizeof", "volatile", "do", "if", "static", "while", "fortran", "pascal", "far", "near"};
    private static final String[] C_SYSWORD_ValType = new String[]{"double", "int", "long", "enum", "register", "char", "float", "short", "void"};
    private static final String[] C_SYSWORD_StructType = new String[]{"else", "switch", "case", "for", "default", "do", "if", "while"};
    private static final String[] C_SYSWORD_StructType2 = new String[]{"break", "return", "continue", "goto"};
    private static final String WORDTYPE1 = "typedef";
    private static HashMap<String, Integer> csysword;
    private static HashMap<String, SentPart[]> extracsysword;

    public WordSystemRev() {
        if (csysword == null) {
            csysword = new HashMap();
            for (int i = 0; i < C_SYSWORD.length; ++i) {
                int j;
                int type = 0;
                if (WORDTYPE1.equals(C_SYSWORD[i])) {
                    type = 1;
                }
                if (type != 0) {
                    csysword.put(C_SYSWORD[i], type);
                    continue;
                }
                for (j = 0; j < C_SYSWORD_ValType.length; ++j) {
                    if (!C_SYSWORD_ValType[j].equals(C_SYSWORD[i])) continue;
                    type = 2;
                    break;
                }
                if (type != 0) {
                    csysword.put(C_SYSWORD[i], type);
                    continue;
                }
                for (j = 0; j < C_SYSWORD_StructType.length; ++j) {
                    if (!C_SYSWORD_StructType[j].equals(C_SYSWORD[i])) continue;
                    type = 3;
                    break;
                }
                for (j = 0; j < C_SYSWORD_StructType2.length; ++j) {
                    if (!C_SYSWORD_StructType2[j].equals(C_SYSWORD[i])) continue;
                    type = 4;
                    break;
                }
                if (type != 0) {
                    csysword.put(C_SYSWORD[i], type);
                    continue;
                }
                csysword.put(C_SYSWORD[i], type);
            }
        }
    }

    public static boolean isStructType2Word(String word) {
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word);
        if (i == null) {
            return false;
        }
        return i == 4;
    }

    public static boolean isStructTypeWord(String word) {
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(word);
        if (i == null) {
            return false;
        }
        return i == 3;
    }

    public static boolean isStructTypeWord(SentPart sp) {
        String word = sp.getWord();
        if (word == null) {
            return false;
        }
        return WordSystemRev.isStructTypeWord(word);
    }

    public static boolean isPrimTypeWord(SentPart sp) {
        String word = sp.getWord();
        if (word == null) {
            return false;
        }
        Integer i = csysword.get(sp.word);
        if (i == null) {
            return false;
        }
        return i == 2;
    }

    public static boolean isUnionStruct(SentPart sp) {
        if (sp == null) {
            return false;
        }
        return sp.word.equals("union") || sp.word.equals("struct");
    }

    public static boolean isTyeDef(SentPart sp) {
        return sp != null && sp.word.equals(WORDTYPE1);
    }

    public void addExtCsWord(ArrayList<SentPart> sps, int idx) {
        SentPart sp = sps.get(idx);
        if (sp == null || !sp.word.equals(WORDTYPE1)) {
            return;
        }
        MyUtil.ArrayObject al = new MyUtil.ArrayObject();
        for (int i = idx + 1; i < sps.size(); ++i) {
            sp = sps.get(idx);
            al.add(sp.clone());
            if (sp.conjunc.equals(";")) break;
        }
        Object[] extsps = new SentPart[al.size()];
        al.toArray(extsps);
        extracsysword.put(((SentPart)extsps[extsps.length - 1]).word, (SentPart[])extsps);
    }

    public static boolean isSysWord(ArrayList<SentPart> sps, int idx) {
        SentPart sp = sps.get(idx);
        if (sp == null) {
            return false;
        }
        Integer o = csysword.get(sp.word);
        return o != null;
    }

    public static boolean isSysWord(SentPart sp) {
        if (sp == null) {
            return false;
        }
        Integer o = csysword.get(sp.word);
        return o != null;
    }

    public SentPart[] getRepSps(ArrayList<SentPart> sps, int idx) {
        SentPart sp = sps.get(idx);
        SentPart[] extsps = extracsysword.get(sp.word);
        if (extsps == null) {
            return null;
        }
        return extsps;
    }

    static {
        extracsysword = new HashMap();
    }
}

