/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import analyzecodeC.WRWordTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.CharBuffer;

public class WRwSplitTr {
    private File infile = null;
    public static final int JAPANESE = 0;
    public static final int C_PROGRAM = 1;
    private int thismode = 0;
    private transient CharBuffer inchars = null;
    private int nowindex = -1;
    private boolean discardchar = false;
    private boolean discarding = false;
    private static final char[][] dischars = new char[][]{{'\f', '\r', '\b', '\t'}, {'\f', '\r', '\b', '\t'}, {'\f', '\r', '\b', '\t', ' '}};
    private transient WRWordTable discparT;
    private transient MyUtil.ObjectSetArray discparE;
    private static final String[][] discardingsPare = new String[][]{new String[0], {"/*", "*/", "//", "\n", "#", "\n"}, {"/*", "*/", "//", "\n", "#", "\n"}};
    private int preEndindex = -1;
    private char[] endTag = null;

    public WRwSplitTr(int mode) {
        this.thismode = mode;
        this.creDisDataTable();
    }

    public WRwSplitTr(int mode, char[] inchars) {
        this(mode);
        this.setInchars(inchars);
    }

    public WRwSplitTr(int mode, File file) {
        this(mode);
        this.infile = file;
    }

    public void setInchars(char[] in) {
        this.inchars = CharBuffer.wrap(in);
    }

    public int getThismode() {
        return this.thismode;
    }

    public boolean first() {
        if (this.inchars == null || this.inchars.length() == 0) {
            if (this.infile == null) {
                return false;
            }
            if (!this.fileLoad(this.infile)) {
                return false;
            }
        }
        this.nowindex = 0;
        this.setDiscarding();
        if (!this.isDicarding()) {
            this.setDiscardChar();
        }
        return true;
    }

    private boolean fileLoad(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader rdr = new BufferedReader(fr);
            int capa = 10000;
            this.inchars = CharBuffer.allocate(capa);
            int len = rdr.read(this.inchars);
            while (len == 10000) {
                CharBuffer tmp = CharBuffer.allocate(capa + 10000);
                this.inchars = tmp.append(this.inchars);
                long ret = rdr.skip(capa);
                if (ret != (long)capa) {
                    return false;
                }
                len = rdr.read(this.inchars);
                capa += 10000;
            }
            rdr.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean next() {
        if (this.inchars.length() == this.nowindex + 1 || this.inchars.get(this.nowindex + 1) == '\u0000') {
            return false;
        }
        ++this.nowindex;
        this.setDiscarding();
        if (!this.isDicarding()) {
            this.setDiscardChar();
        }
        return true;
    }

    private void setDiscardChar() {
        for (int i = 0; i < dischars[this.thismode].length; ++i) {
            if (dischars[this.thismode][i] != this.inchars.get(this.nowindex)) continue;
            this.discardchar = true;
            return;
        }
        this.discardchar = false;
    }

    private void creDisDataTable() {
        this.discparT = new WRWordTable();
        this.discparE = new MyUtil.ObjectSetArray();
        for (int i = 0; i < discardingsPare[this.thismode].length; ++i) {
            Integer wid = this.discparT.wordToWid(discardingsPare[this.thismode][i++], true);
            this.discparE.set(wid, discardingsPare[this.thismode][i]);
        }
    }

    private void setDiscarding() {
        if (this.endTag != null) {
            for (int i = 0; i < this.endTag.length; ++i) {
                if (this.endTag[i] == this.inchars.get(this.nowindex + i)) continue;
                return;
            }
            this.preEndindex = this.nowindex + this.endTag.length - 1;
            this.endTag = null;
        }
        if (this.preEndindex >= 0) {
            if (this.nowindex < this.preEndindex) {
                return;
            }
            this.preEndindex = -1;
            return;
        }
        if (this.discparT.getWids(this.inchars.array(), this.nowindex)) {
            MyUtil.PrimitiveArrayII tags = this.discparT.getWidsOutWidLen();
            tags.last();
            int lastidx = tags.previousIdxKey();
            int tagsid = tags.latestValue();
            this.endTag = ((String)this.discparE.get(tagsid)).toCharArray();
            this.discarding = true;
        } else {
            this.discarding = false;
        }
    }

    public boolean isDicarding() {
        return this.discarding;
    }

    public boolean isDiscardchar() {
        return this.discardchar;
    }

    public char getChar() {
        return this.inchars.get(this.nowindex);
    }
}

