/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import analyzecodeC.SentPart;
import analyzecodeC.WRWordTable;
import analyzecodeC.WRwSplitTr;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WRwSplitChars {
    private WRwSplitTr wst = null;
    private static transient WRWordTable[] wtbls = new WRWordTable[3];
    private static transient WRWordTable[] wtblsword = new WRWordTable[3];
    private char[] chars = new char[100];
    private int index = 0;
    private int conjidx = 0;
    private int conjlastidx = -1;
    private static final String[][] inisplitchar = new String[][]{{"\u3002", ".", "\n"}, {".", "->", "=", ";", "<", ">", ",", "\n", " ", "==", "!=", "&=", "+=", "-=", "%=", "*=", "/=", "^=", ">=", "<=", "|=", "+", "++", "-", "--", "&&", "|", "||", "^", "~", "/", "%", "(", ")", "{", "}", "<<", ">>", "<<=", ">>=", "!", "?", ":"}, {".", "=", ";", "<", ">", ",", " ", "==", "!=", "&=", "+=", "-=", "%=", "*=", "/=", "^=", ">=", "<=", "|=", "&=", "~=", "+", "++", "-", "--", "&", "&&", "|", "||", "^", "~", "*", "/", "%", "(", ")", "{", "}"}};
    private static final String[][] inisplitWordchar = new String[][]{new String[0], {"*", "&"}, new String[0]};
    private static final char[] stringMark = new char[]{' ', '\"', '\"'};
    private static final String[] cmpMark = new String[]{"<", ">", "==", "!=", ">=", "<=", "&&", "||"};
    private static final String[] settoMark = new String[]{"=", "&=", "+=", "-=", "%=", "*=", "/=", "^=", "|=", "<<=", ">>="};
    private ArrayList<SentPart> sps = null;
    private static final int OFFSET = 10;
    private boolean nextstrmark = false;

    public WRwSplitChars(WRwSplitTr tr) {
        this.wst = tr;
        if (wtbls[0] == null) {
            WRwSplitChars.setWtbls();
        }
    }

    private static void setWtbls() {
        for (int i = 0; i < wtbls.length; ++i) {
            WRwSplitChars.wtbls[i] = new WRWordTable();
            WRwSplitChars.wtblsword[i] = new WRWordTable();
            for (int j = 0; j < inisplitchar[i].length; ++j) {
                wtbls[i].wordToWid(inisplitchar[i][j], true);
                if (inisplitWordchar[i].length <= j) continue;
                wtblsword[i].wordToWid(inisplitWordchar[i][j], true);
            }
        }
    }

    public static WRWordTable getWtbls(int mode) {
        if (mode >= wtbls.length) {
            return null;
        }
        if (wtbls == null || wtbls[0] == null) {
            WRwSplitChars.setWtbls();
        }
        return wtbls[mode];
    }

    public static boolean isKakkoStart(String conj) {
        return conj.equals("(") || conj.equals("{");
    }

    public static boolean isKakkoEnd(String conj) {
        return conj.equals(")") || conj.equals("}");
    }

    public static boolean isCompMark(String conj) {
        for (int i = 0; i < cmpMark.length; ++i) {
            if (!cmpMark[i].equals(conj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSettoMark(String conj) {
        for (int i = 0; i < settoMark.length; ++i) {
            if (!settoMark[i].equals(conj)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSettoMarkEle(String conj) {
        return conj.equals("=");
    }

    private MyUtil.PrimitiveArrayII isInisplitchar() {
        int mode = this.wst.getThismode();
        WRWordTable sconj = wtbls[mode];
        if (sconj.getWids(this.chars, this.conjidx)) {
            return sconj.getWidsOutWidLen();
        }
        return null;
    }

    private SentPart[] splitWordchar(StringBuffer wordbuf, StringBuffer conjbuf) {
        SentPart[] retval = new SentPart[2];
        int mode = this.wst.getThismode();
        WRWordTable sconj = wtblsword[mode];
        int size = wordbuf.length();
        char[] wb = new char[size];
        wordbuf.getChars(0, wb.length, wb, 0);
        for (int i = 1; i < wb.length; ++i) {
            if (!sconj.getWids(wb, i)) continue;
            MyUtil.PrimitiveArrayII cids = sconj.getWidsOutWidLen();
            cids.last();
            int lastidx = cids.previousIdxKey();
            String word = new String(this.chars, 0, i);
            String conj = new String(this.chars, i, lastidx - i + 1);
            String word2 = new String(this.chars, lastidx - i + 1, size);
            retval[0] = new SentPart(word, conj);
            retval[1] = new SentPart(word2, conjbuf.toString());
            return retval;
        }
        return null;
    }

    public static SentPart[] splitWordchar(int mode, SentPart sp) {
        WRWordTable sconj = wtblsword[mode];
        char[] inchars = sp.word.toCharArray();
        for (int i = 1; i < inchars.length; ++i) {
            if (!sconj.getWids(inchars, i)) continue;
            SentPart[] retval = new SentPart[2];
            MyUtil.PrimitiveArrayII cids = sconj.getWidsOutWidLen();
            cids.last();
            int lastidx = cids.previousIdxKey();
            String word = new String(inchars, 0, i);
            String conj = new String(inchars, i, lastidx - i + 1);
            String word2 = new String(inchars, lastidx - i + 1, sp.word.length());
            retval[0] = new SentPart(word, conj);
            retval[1] = new SentPart(word2, sp.getConjunc());
            return retval;
        }
        return null;
    }

    private int getConjid(MyUtil.PrimitiveArrayII sconj) {
        sconj.last();
        int lastidx = sconj.previousIdxKey();
        int conjid = sconj.latestValue();
        return conjid;
    }

    private int getLastIdx(MyUtil.PrimitiveArrayII sconj) {
        sconj.last();
        int lastidx = sconj.previousIdxKey();
        int conjid = sconj.latestValue();
        return lastidx;
    }

    public ArrayList<SentPart> getSps() {
        return this.sps;
    }

    public SentPart[] getSpsArray() {
        if (this.sps == null) {
            return null;
        }
        SentPart[] retval = new SentPart[this.sps.size()];
        this.sps.toArray(retval);
        return retval;
    }

    public void creSps() {
        this.sps = new ArrayList();
        StringBuffer word = new StringBuffer();
        StringBuffer conj = new StringBuffer();
        if (!this.wst.first()) {
            return;
        }
        this.initChars();
        do {
            char c;
            if (this.wst.isDicarding() || this.wst.isDiscardchar() || this.addChars(c = this.wst.getChar()) || this.chkChars()) continue;
            this.addSps2(word, conj);
            this.updateChars();
        } while (this.wst.next());
        for (int i = 0; i <= 10 && i < this.index; ++i) {
            if (this.chkChars()) continue;
            this.addSps2(word, conj);
            this.updateChars();
            i = 0;
        }
        if (this.index > 0) {
            this.addSps2(word, conj);
        }
    }

    private void addSps2(StringBuffer word, StringBuffer conj) {
        SentPart ws;
        boolean normal = true;
        if (this.conjlastidx < 0) {
            return;
        }
        char strc = stringMark[this.wst.getThismode()];
        if (strc == this.chars[this.conjidx] && strc == this.chars[this.conjlastidx]) {
            word.append(this.chars, this.conjidx, this.conjlastidx - this.conjidx + 1);
            ws = new SentPart(word.toString(), conj.toString());
            this.sps.add(ws);
            normal = false;
        } else {
            word.append(this.chars, 0, this.conjidx);
            conj.append(this.chars, this.conjidx, this.conjlastidx - this.conjidx + 1);
        }
        if (normal) {
            ws = new SentPart(word.toString(), conj.toString());
            this.sps.add(ws);
        }
        word.delete(0, word.length());
        conj.delete(0, conj.length());
    }

    private boolean addChars(char inc) {
        if (this.index + 1 >= this.chars.length) {
            return false;
        }
        if (this.index > 0 && (this.chars[this.index - 1] == '\t' || this.chars[this.index - 1] == '\n' || this.chars[this.index - 1] == ' ') && this.chars[this.index - 1] == inc) {
            return true;
        }
        this.chars[this.index++] = inc;
        return this.index - this.conjidx <= 10;
    }

    private boolean chkChars() {
        MyUtil.PrimitiveArrayII conjids;
        char str = stringMark[this.wst.getThismode()];
        if (this.nextstrmark) {
            if (this.conjidx != 0) {
                this.conjlastidx = this.conjidx;
                return false;
            }
            this.conjlastidx = 1;
            while ((this.chars[this.conjlastidx] != str || this.chars[this.conjlastidx - 1] == '\\') && this.conjlastidx < this.index) {
                ++this.conjlastidx;
            }
            if (this.conjlastidx == this.index) {
                this.conjlastidx = -1;
                return true;
            }
            this.nextstrmark = false;
            return false;
        }
        if (str == this.chars[this.conjidx + 1] && this.chars[this.conjidx] != '\\') {
            this.nextstrmark = true;
        }
        if ((conjids = this.isInisplitchar()) == null) {
            ++this.conjidx;
            this.conjlastidx = -1;
            return true;
        }
        this.conjlastidx = this.getLastIdx(conjids) + this.conjidx;
        return false;
    }

    private void updateChars() {
        try {
            System.arraycopy(this.chars, this.conjlastidx + 1, this.chars, 0, this.index - this.conjlastidx - 1);
        }
        catch (Exception e) {
            throw new Error();
        }
        this.index -= this.conjlastidx + 1;
        this.conjidx = 0;
        this.conjlastidx = -1;
    }

    private void initChars() {
        this.index = 0;
        this.conjidx = 0;
        this.conjlastidx = -1;
    }
}

