/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.MyUtil;
import java.io.Serializable;

public class WRWordTable
implements Serializable {
    private static final long serialVersionUID = 200710272000001L;
    private MyUtil.ArrayObject columns = new MyUtil.ArrayObject();
    private MyUtil.ObjectSetArray norWClinkTop = new MyUtil.ObjectSetArray();
    private MyUtil.ArrayObject wordids = new MyUtil.ArrayObject();
    private MyUtil.PrimitiveArrayII widhash = new MyUtil.PrimitiveArrayII();
    private MyUtil.PrimitiveArrayI uncommitWidList = new MyUtil.PrimitiveArrayI();
    private MyUtil.PrimitiveArrayI removedWidList = new MyUtil.PrimitiveArrayI();
    private transient MyUtil.ArrayObject splitWidOutWords;
    private transient MyUtil.ArrayObject splitWidOutWids;
    private transient MyUtil.PrimitiveArrayII getWidsOutWidLen;
    private static final int WC_WOFEND = -2;
    private static final int WC_NULL = -1;

    public Integer wordToWid(String word, boolean hunt) {
        int wid = this.searchWord(word);
        if (wid > 0) {
            if (this.wordids.isRemoved(wid)) {
                return null;
            }
            return new Integer(wid);
        }
        if (!hunt) {
            return null;
        }
        wid = this.huntValueLink(word);
        return wid > 0 ? new Integer(wid) : null;
    }

    private int searchWord(String value) {
        if (value == null || value.length() == 0) {
            return -1;
        }
        char[] ca = value.toCharArray();
        WordColumn wc = this.getNorLink(ca[0]);
        if (wc == null) {
            return -1;
        }
        int idx = value.hashCode();
        int wids = -1;
        try {
            wids = this.widhash.getValues(idx);
        }
        catch (Exception e) {
            return -1;
        }
        do {
            int port;
            if ((port = wc.getWidStartPort(wids)) < 0) {
                return -1;
            }
            if (this.traceWordIdLink(wc, port, ca) != ca.length - 1) continue;
            return wids;
        } while ((wids = this.widhash.getValuesCont(idx)) > 0);
        return -1;
    }

    private int traceWordIdLink(WordColumn start, int startport, char[] cas) {
        WordColumn my = start;
        int myport = startport;
        for (int i = 0; i < cas.length - 1; ++i) {
            if (my.isWOFE(myport)) {
                return i;
            }
            int nextport = my.getNextWCport(myport);
            if (nextport < 0) {
                return -1;
            }
            WordColumn next = my.getNextWC(myport);
            if (next.value != cas[i + 1]) {
                return -1;
            }
            myport = nextport;
            my = next;
        }
        return my.isWOFE(myport) ? cas.length - 1 : -1;
    }

    private String getWord(WordColumn start, int startport) {
        StringBuffer retval = new StringBuffer();
        WordColumn my = start;
        int myport = startport;
        while (my != null) {
            retval.append(my.value);
            int nextport = my.getNextWCport(myport);
            if (nextport < 0) break;
            my = my.getNextWC(myport);
            myport = nextport;
        }
        return retval.toString();
    }

    private synchronized int huntValueLink(String value) {
        if (value == null || value.length() == 0) {
            return -1;
        }
        char[] ca = value.toCharArray();
        int[] idlist = new int[ca.length];
        WordColumn[] wclist = new WordColumn[ca.length];
        int wid = this.huntRemoveWid(-1);
        if (wid < 0) {
            return -1;
        }
        for (int i = 0; i < ca.length; ++i) {
            WordColumn wc = this.getWCfromNorLink(ca[i]);
            idlist[i] = wc.id;
            wclist[i] = wc;
        }
        int beforport = -1;
        for (int i = 0; i < wclist.length; ++i) {
            int portno;
            int n = portno = i == 0 ? wclist[i].addWordLink(null, beforport, wid) : wclist[i].addWordLink(wclist[i - 1], beforport, wid);
            if (i > 0) {
                wclist[i - 1].setWordLinkNext(beforport, wclist[i], portno);
            }
            beforport = portno;
        }
        this.wordids.setValue(wid, idlist);
        this.widhash.addSort(value.hashCode(), wid);
        return wid;
    }

    private int huntRemoveWid(int wid) {
        boolean hunt;
        boolean bl = hunt = wid < 0;
        if (hunt) {
            int retval = -1;
            if (this.removedWidList.isEmpty()) {
                retval = this.wordids.addItem(null);
                if (retval == 0) {
                    retval = this.wordids.addItem(null);
                }
            } else {
                this.removedWidList.first();
                retval = this.removedWidList.next();
                this.removedWidList.remove();
                this.wordids.setValue(retval, null);
            }
            if (retval > 0) {
                this.uncommitWidList.addSort(retval);
            }
            return retval;
        }
        this.wordids.removeItem(wid);
        int idx = this.uncommitWidList.indexofSorted(wid);
        this.uncommitWidList.remove(idx);
        this.removedWidList.add(wid);
        return -1;
    }

    public MyUtil.PrimitiveArrayI getUncommitWid() {
        return this.uncommitWidList;
    }

    public void commitWid(int wid) {
        int idx = this.uncommitWidList.indexofSorted(wid);
        this.uncommitWidList.remove(idx);
    }

    public int getMaxWid() {
        return this.wordids.size();
    }

    public String widToWord(Integer wid) {
        return this.widToWord((int)wid);
    }

    public String widToWord(int wid) {
        if (this.wordids.isRemoved(wid)) {
            return null;
        }
        int[] idlist = (int[])this.wordids.getValue(wid);
        if (idlist == null) {
            return null;
        }
        WordColumn wc = (WordColumn)this.columns.getValue(idlist[0]);
        int startport = wc.getWidStartPort(wid);
        if (startport < 0) {
            return null;
        }
        String retval = this.getWord(wc, startport);
        return retval;
    }

    public MyUtil.ArrayObject getSplitWidOutWords() {
        return this.splitWidOutWords;
    }

    public MyUtil.ArrayObject getSplitWidOutWids() {
        return this.splitWidOutWids;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean splitWid(String word) {
        boolean retval = false;
        this.splitWidOutWords = new MyUtil.ArrayObject();
        this.splitWidOutWids = new MyUtil.ArrayObject();
        if (word == null || word.length() == 0) {
            return false;
        }
        char[] ca = word.toCharArray();
        WordColumn[] wclist = new WordColumn[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            WordColumn wc;
            wclist[i] = wc = this.getNorLink(ca[i]);
        }
        MyUtil.PrimitiveArrayII bakwidsidx = null;
        char[] bakca2 = null;
        int bak_i = -1;
        int idx = -1;
        int id = -1;
        StringBuffer unknown = new StringBuffer();
        char[] ca2 = ca;
        int i = 0;
        while (i < wclist.length) {
            block11: {
                block12: {
                    boolean getwid;
                    boolean bl = getwid = wclist[i] != null ? this.getWids(wclist[i], ca2) : false;
                    if (getwid) break block12;
                    if (bakwidsidx != null) {
                        this.splitWidOutWords.removeLast();
                        this.splitWidOutWids.removeLast();
                        ca2 = bakca2;
                        i = bak_i;
                        if (bakwidsidx.hasPrevious()) {
                            idx = bakwidsidx.previousIdxKey();
                            id = bakwidsidx.latestValue();
                            break block11;
                        } else {
                            bakwidsidx.last();
                            idx = bakwidsidx.previousIdxKey();
                            id = bakwidsidx.latestValue();
                            bakwidsidx = null;
                        }
                        break block11;
                    } else {
                        unknown.append(ca2[0]);
                        ca2 = this.charsTochars(ca2, 1);
                        ++i;
                        continue;
                    }
                }
                retval = true;
                if (unknown.length() > 0) {
                    this.splitWidOutWords.add(unknown.toString());
                    this.splitWidOutWids.add(null);
                    unknown = new StringBuffer();
                }
                bakwidsidx = this.getWidsOutWidLen;
                bakca2 = ca2;
                bak_i = i;
                bakwidsidx.last();
                idx = bakwidsidx.hasPrevious() ? bakwidsidx.previousIdxKey() : -1;
                id = bakwidsidx.latestValue();
            }
            if (idx < 0) {
                return false;
            }
            this.splitWidOutWords.add(this.charsToString(ca2, idx));
            this.splitWidOutWids.add(new Integer(id));
            int newsize = ca2.length - idx - 1;
            if (newsize == 0) {
                return retval;
            }
            ca2 = this.charsTochars(ca2, idx + 1);
            i += idx + 1;
        }
        if (unknown.length() > 0) {
            this.splitWidOutWords.add(unknown.toString());
            this.splitWidOutWids.add(null);
        }
        return retval;
    }

    private char[] charsTochars(char[] ca, int newIdx0) {
        int newsize = ca.length - newIdx0;
        if (newsize == 0) {
            return null;
        }
        char[] ca2 = new char[newsize];
        System.arraycopy(ca, newIdx0, ca2, 0, newsize);
        return ca2;
    }

    private String charsToString(char[] cas, int tailidx) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i <= tailidx; ++i) {
            retval.append(cas[i]);
        }
        return retval.toString();
    }

    public boolean hasWid(char first) {
        WordColumn wc = this.getNorLink(first);
        if (wc == null) {
            return false;
        }
        return wc.hasStartPort();
    }

    private boolean getWids(WordColumn wc, char[] cas) {
        this.getWidsOutWidLen = new MyUtil.PrimitiveArrayII();
        MyUtil.PrimitiveArrayI ports = wc.getStartPorts();
        ports.first();
        while (ports.hasNext()) {
            int port = ports.next();
            int idx = this.traceWordIdLink(wc, port, cas);
            if (idx < 0) continue;
            this.getWidsOutWidLen.addSort(idx, wc.getWid(port));
        }
        return !this.getWidsOutWidLen.isEmpty();
    }

    public boolean getWids(char[] ca, int idx) {
        if (idx < 0 || ca.length <= idx) {
            return false;
        }
        WordColumn wc = this.getNorLink(ca[idx]);
        if (wc == null) {
            return false;
        }
        if (idx > 0) {
            char[] ca2 = this.charsTochars(ca, idx);
            return this.getWids(wc, ca2);
        }
        return this.getWids(wc, ca);
    }

    public MyUtil.PrimitiveArrayII getWidsOutWidLen() {
        return this.getWidsOutWidLen;
    }

    public MyUtil.PrimitiveArrayI getWids(char ca) {
        MyUtil.PrimitiveArrayI retval = new MyUtil.PrimitiveArrayI();
        WordColumn wc = this.getNorLink(ca);
        if (wc == null) {
            return retval;
        }
        MyUtil.PrimitiveArrayI ports = wc.getStartPorts();
        while (ports.hasNext()) {
            int port = ports.next();
            retval.addSort(wc.getWid(port));
        }
        return retval;
    }

    public void removeWord(String word) {
        Integer wid = this.wordToWid(word, false);
        if (wid == null) {
            return;
        }
        this.removeWid(wid);
    }

    public synchronized void removeWid(Integer wordid) {
        int wid = wordid;
        int[] idlist = (int[])this.wordids.getValue(wid);
        if (idlist == null) {
            return;
        }
        WordColumn wc = (WordColumn)this.columns.getValue(idlist[0]);
        int startport = wc.getWidStartPort(wid);
        if (startport < 0) {
            return;
        }
        WordColumn my = wc;
        int myport = startport;
        while (my != null) {
            int nextport = my.getNextWCport(myport);
            WordColumn next = my.getNextWC(myport);
            my.removePort(wid, myport);
            if (next == null) break;
            myport = nextport;
            my = next;
        }
        this.huntRemoveWid(wid);
    }

    private static int calNorid(char ca) {
        int retval = new Character(ca).hashCode();
        return retval &= 0xFF;
    }

    private void putNorLink(WordColumn wc) {
        int[] renew;
        int nor = WRWordTable.calNorid(wc.value);
        int[] idlist = (int[])this.norWClinkTop.get(nor);
        if (idlist == null) {
            renew = new int[1];
        } else {
            renew = new int[idlist.length + 1];
            System.arraycopy(idlist, 0, renew, 0, idlist.length);
        }
        renew[renew.length - 1] = wc.id;
        this.norWClinkTop.set(nor, renew);
    }

    private WordColumn getWCfromNorLink(char ca) {
        WordColumn wc = this.getNorLink(ca);
        if (wc == null) {
            wc = new WordColumn(ca);
            int coid = this.columns.addItem(wc);
            wc.id = coid;
            this.putNorLink(wc);
        }
        return wc;
    }

    private WordColumn getNorLink(char ca) {
        int nor = WRWordTable.calNorid(ca);
        int[] idlist = (int[])this.norWClinkTop.get(nor);
        if (idlist == null) {
            return null;
        }
        for (int i = 0; i < idlist.length; ++i) {
            WordColumn wc = (WordColumn)this.columns.getValue(idlist[i]);
            if (wc.value != ca) continue;
            return wc;
        }
        return null;
    }

    private class WordColumn
    implements Serializable {
        private static final long serialVersionUID = 200710272000003L;
        private char value;
        private int id;
        private int size = 0;
        private MyUtil.PrimitiveArrayII wordidLinksIdx = new MyUtil.PrimitiveArrayII();
        private int[] wordidLinksNext;
        private int[] wordidLinksNextport;
        private int[] wordidLinksForward;
        private int[] wordidLinksForwardport;
        private MyUtil.PrimitiveArrayI rmports = new MyUtil.PrimitiveArrayI();

        private WordColumn(char value) {
            this.value = value;
        }

        private synchronized int addWordLink(WordColumn forwardwc, int forport, int wordid) {
            if (forwardwc == null) {
                forport = -1;
            }
            int editidx = this.getPort();
            if (forwardwc == null) {
                this.wordidLinksIdx.addSort(wordid, editidx);
            }
            this.wordidLinksForward[editidx] = forwardwc == null ? -1 : forwardwc.id;
            this.wordidLinksForwardport[editidx] = forwardwc == null ? -1 : forport;
            this.wordidLinksNext[editidx] = -1;
            this.wordidLinksNextport[editidx] = -2;
            return editidx;
        }

        private int getPort() {
            int retval = -1;
            if (!this.rmports.isEmpty()) {
                this.rmports.first();
                retval = this.rmports.next();
                this.rmports.remove();
            }
            if (retval < 0) {
                if (this.wordidLinksNext == null || this.size == this.wordidLinksNext.length - 2) {
                    this.wordidLinksNext = this.incIntArrayList(this.wordidLinksNext);
                    this.wordidLinksNextport = this.incIntArrayList(this.wordidLinksNextport);
                    this.wordidLinksForward = this.incIntArrayList(this.wordidLinksForward);
                    this.wordidLinksForwardport = this.incIntArrayList(this.wordidLinksForwardport);
                }
                retval = this.size++;
            }
            return retval;
        }

        private synchronized void removePort(int wid, int portno) {
            if (portno >= this.wordidLinksForward.length || portno < 0) {
                return;
            }
            this.wordidLinksIdx.remove(wid, portno);
            this.wordidLinksForward[portno] = -1;
            this.wordidLinksForwardport[portno] = -1;
            this.wordidLinksNext[portno] = -1;
            this.wordidLinksNextport[portno] = -1;
            this.rmports.addSort(portno);
        }

        private void setWordLinkNext(int setport, WordColumn nextwc, int nextport) {
            if (nextwc == null) {
                throw new NullPointerException();
            }
            this.wordidLinksNext[setport] = nextwc.id;
            this.wordidLinksNextport[setport] = nextport;
        }

        private int getNextWCport(int portno) {
            if (this.wordidLinksNext.length <= portno) {
                throw new IllegalArgumentException();
            }
            if (portno < 0) {
                throw new IllegalArgumentException();
            }
            return this.wordidLinksNextport[portno];
        }

        private WordColumn getNextWC(int portno) {
            if (this.wordidLinksNext.length <= portno) {
                throw new IllegalArgumentException();
            }
            if (portno < 0) {
                throw new IllegalArgumentException();
            }
            WordColumn wc = (WordColumn)WRWordTable.this.columns.getValue(this.wordidLinksNext[portno]);
            return wc;
        }

        private boolean isWOFE(int portno) {
            if (this.wordidLinksNext.length <= portno) {
                return false;
            }
            if (portno < 0) {
                return false;
            }
            return this.wordidLinksNextport[portno] == -2;
        }

        private int getWidStartPort(int wid) {
            int idx = this.wordidLinksIdx.getValues(wid);
            if (idx < 0) {
                return -1;
            }
            if (this.wordidLinksForwardport[idx] == -1 && this.wordidLinksNextport[idx] != -1) {
                return idx;
            }
            while (idx >= 0) {
                idx = this.wordidLinksIdx.getValuesCont(wid);
                if (idx < 0) {
                    return -1;
                }
                if (this.wordidLinksForwardport[idx] != -1 || this.wordidLinksNextport[idx] == -1) continue;
                return idx;
            }
            return -1;
        }

        private MyUtil.PrimitiveArrayI getStartPorts() {
            MyUtil.PrimitiveArrayI retval = this.wordidLinksIdx.getValues();
            return retval;
        }

        private boolean hasStartPort() {
            return !this.wordidLinksIdx.isEmpty();
        }

        private int getWid(int portno) {
            return this.wordidLinksIdx.getIdxKey(portno);
        }

        private int[] incIntArrayList(int[] array) {
            int[] retval;
            if (array == null) {
                retval = new int[100];
            } else {
                int inc = array.length / 2;
                inc = inc < 100 ? 100 : (inc > 1000 ? 1000 : inc);
                retval = new int[array.length + inc];
                System.arraycopy(array, 0, retval, 0, array.length);
            }
            return retval;
        }
    }
}

