/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.PatternSyntaxException;

public class SentPart
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 200903273900001L;
    protected String word;
    protected String conjunc;
    private Integer wordid;
    private boolean commit = false;
    private boolean sentend = false;
    private Object value;
    private boolean mailaddr = false;

    public SentPart(String word, String conj) {
        this.word = word;
        this.conjunc = conj;
    }

    protected SentPart(String word, String conj, Integer wid) {
        this(word, conj);
        this.wordid = wid;
        if (wid != null) {
            this.commit = true;
        }
    }

    public SentPart(Object value) {
        this.word = null;
        this.conjunc = null;
        this.wordid = null;
        this.setValue(value);
    }

    public void setValue(Object vale) {
        this.value = vale;
        if (vale instanceof String && ((String)this.value).matches(".*@.*")) {
            this.mailaddr = true;
        }
        this.word = null;
        this.wordid = null;
        if (this.value != null) {
            this.commit = true;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isValue() {
        return this.value != null;
    }

    public boolean isMailAdr() {
        return this.mailaddr;
    }

    private void setWordid(Integer wid) {
        if (this.isValue()) {
            return;
        }
        this.wordid = wid;
        if (wid != null) {
            this.commit = true;
        }
    }

    public void setSentEnd(boolean sentend) {
        this.sentend = sentend;
    }

    public boolean isSentEnd() {
        return this.sentend;
    }

    public boolean isCommit() {
        return this.commit;
    }

    protected Integer getWordId() {
        return this.wordid;
    }

    protected Object clone() {
        Object retValue = null;
        try {
            retValue = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return retValue;
    }

    public String getWord() {
        String retval = this.word;
        if (this.isValue()) {
            if (this.value instanceof Date) {
                String aaa;
                SimpleDateFormat smdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u6642mm\u5206");
                DateFormat df = smdf.getDateInstance();
                retval = df.format((Date)this.value);
                retval = aaa = this.value.toString();
            } else {
                retval = this.value.toString();
            }
        }
        return retval;
    }

    public void setWord(String word) {
        if (word == null) {
            word = "";
        }
        if (!this.isValue()) {
            this.word = word;
            this.wordid = null;
            this.commit = false;
        } else {
            this.value = word;
        }
    }

    public String getConjunc() {
        return this.conjunc;
    }

    public void setConjunc(String conj) {
        this.conjunc = conj;
    }

    public boolean contain(String inword, String inconj) {
        if (inword != null) {
            if (this.isValue()) {
                if (!(inword instanceof String)) {
                    return false;
                }
                if (!this.value.equals(inword)) {
                    return false;
                }
            } else {
                if (this.word == null) {
                    return false;
                }
                if (!this.word.equals(inword) && !this.word.matches(inword)) {
                    return false;
                }
            }
            if (inconj == null) {
                return true;
            }
            if (this.conjunc == null) {
                return false;
            }
            return this.conjunc.equals(inconj) || this.conjunc.matches(inconj);
        }
        if (inconj == null) {
            return true;
        }
        try {
            return this.conjunc.equals(inconj) || this.conjunc.matches(inconj);
        }
        catch (PatternSyntaxException pse) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SentPart)) {
            return false;
        }
        SentPart insp = (SentPart)obj;
        if (this.word != null && insp.word != null) {
            if (!this.word.equals(insp.word)) {
                return false;
            }
        } else {
            return false;
        }
        if (this.conjunc != null && insp.conjunc != null ? !this.conjunc.equals(insp.conjunc) : this.conjunc != insp.conjunc) {
            return false;
        }
        if (this.wordid != null && insp.wordid != null ? !this.wordid.equals(insp.wordid) : this.wordid != insp.wordid) {
            return false;
        }
        if (this.value != null && insp.value != null ? !this.value.equals(insp.value) : this.value != insp.value) {
            return false;
        }
        return this.commit == insp.commit;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[");
        if (this.value != null) {
            retval.append("value=");
            retval.append(this.value.toString());
            retval.append(",");
        }
        if (this.word != null) {
            retval.append(this.word);
            retval.append(" ");
        }
        if (this.conjunc != null) {
            retval.append(this.conjunc);
        }
        retval.append("]");
        return retval.toString();
    }
}

