/*
 * Decompiled with CFR 0.152.
 */
package analyzecodeC;

import analyzecodeC.SentPart;
import analyzecodeC.WRwSplitChars;
import analyzecodeC.WRwSplitTr;
import analyzecodeC.WordSystemRev;
import analyzecodeC.decode.Function;
import analyzecodeC.decode.ProcessKakko;
import analyzecodeC.decode.ProcessRoute;
import analyzecodeC.decode.SpsTranzaction;
import analyzecodeC.erlang.ErlangCreator;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeCodeCM
implements Serializable {
    private static final long serialVersionUID = 201002070101000001L;
    public static final boolean DEBUG = true;
    public static String DBGLOGFILE1 = "C:\\job_dir\\log\\ctoerldebuglog.txt";
    private static final int MYTYPE = 1;
    private static HashMap<String, ProcessKakko> filedatas;
    public static boolean AUTO_SMP;
    private static transient WordSystemRev wordsys;
    private String pathdir = null;
    private String erlfile = null;
    private String cfile = null;
    private String modname = null;
    private static String savfile;
    public static final String STUBNAME = "ctoerlstub";
    private static HashMap<String, Function> funclist;

    public AnalyzeCodeCM(boolean dataload) {
        if (dataload) {
            AnalyzeCodeCM tmp = AnalyzeCodeCM.readFileDat(savfile);
            if (tmp != null) {
                if (filedatas == null) {
                    filedatas = new HashMap();
                }
                if (funclist == null) {
                    funclist = new HashMap();
                }
                this.cfile = tmp.cfile;
                this.erlfile = tmp.erlfile;
                this.pathdir = tmp.pathdir;
                this.modname = tmp.modname;
            } else {
                filedatas = new HashMap();
                funclist = new HashMap();
            }
        } else if (filedatas == null || funclist == null) {
            filedatas = new HashMap();
            funclist = new HashMap();
        }
    }

    public AnalyzeCodeCM() {
        this(true);
    }

    public static ProcessKakko getFileData(String filename) {
        return filedatas.get(filename);
    }

    public static ProcessKakko[] getFileDatas() {
        Collection<ProcessKakko> co = filedatas.values();
        return co.toArray(new ProcessKakko[co.size()]);
    }

    public String sizeFiledats() {
        return new Integer(filedatas.size()).toString();
    }

    public String sizeFuncList() {
        return new Integer(funclist.size()).toString();
    }

    public void init() {
        filedatas = new HashMap();
        funclist = new HashMap();
        AnalyzeCodeCM.saveFileDat(savfile, this);
    }

    public void creErlangFile(ProcessKakko pk) {
        int i;
        this.pathdir = pk.getPath();
        this.cfile = this.erlfile = pk.getModname();
        this.erlfile = this.modname + ".erl";
        StringBuffer retval = new StringBuffer();
        retval.append(ErlangCreator.creErlfileTopModule(pk));
        ProcessKakko[] pks = pk.getChildPks();
        for (i = 0; i < pks.length; ++i) {
            retval.append(ErlangCreator.creErlfileTopExport(pks[i]));
        }
        retval.append(ErlangCreator.creErlfileTopSouce(pk));
        for (i = 0; i < pks.length; ++i) {
            retval.append(this.creErlSource(pks[i]));
        }
        this.putErlsource(this.pathdir + "\\" + this.erlfile, retval.toString());
    }

    public void creStubFile() {
        StringBuffer retval = new StringBuffer();
        retval.append("-module(ctoerlstub).\n");
        retval.append("-export([gval_insert/3,gval_insert/2,gval_new/1]).\n");
        retval.append("-export([gval_lookup/2]).\n");
        retval.append("-export([array_val_set/3]).\n");
        Collection<Function> frs = funclist.values();
        for (Function fr : frs) {
            if (!fr.isLiblary()) continue;
            retval.append(fr.getErlfileTopExport());
        }
        retval.append("\n");
        retval.append("gval_insert([],[],[])->false;\ngval_insert([TBN],[TK],[TV])->\n  ets:insert(TBN,{TK,TV});\n\ngval_insert([TBN|TBNL],[TK|BK],[TV|BV])->\n  ets:insert(TBN,{TK,TV}),\n  gval_insert(TBNL,BK,BV);\n\ngval_insert(Tbn,Key,Val)->\n  ets:insert(Tbn,{Key,Val}).\n\ngval_insert(Tbn,Val)->\n  ets:insert(Tbn,{null,Val}).\n\ngval_new([])->false;\ngval_new([TN])->\n  table_new(TN);\ngval_new([TN|TNL])->\n  table_new(TN),\n  gval_new(TNL).\n\ntable_new(Tbl)->\n  case ets:info(Tbl) of\n    undefined ->\n      ets:new(Tbl,[public,set,named_table]);\n    _        ->\n      false\n  end.\n\n");
        retval.append("gval_lookup(Tbn,Key)->\n  case ets:lookup(Tbn,Key) of \n    [{_,Val}] -> Val;\n    []->0\n  end.\n\n");
        retval.append("array_val_set([H],TBN,CNT)->\n  ets:insert(TBN,{CNT,H});\narray_val_set([H|T],TBN,CNT)->\n  ets:insert(TBN,{CNT,H}),\n  array_val_set(T,TBN,CNT+1).\n");
        for (Function fr : frs) {
            if (!fr.isLiblary()) continue;
            retval.append(fr.getErlFuncStbCode());
        }
        String outfile = this.pathdir + "\\" + STUBNAME + ".erl";
        this.putErlsource(outfile, retval.toString());
    }

    public String creErlSource(ProcessKakko fpk) {
        ProcessRoute pr = fpk.getRoutes();
        ErlangCreator ec = new ErlangCreator(pr);
        String retval = ec.creErlSource(fpk);
        return retval;
    }

    public static String getSavfile() {
        return savfile;
    }

    public static void setSavfile(String savfile) {
        AnalyzeCodeCM.savfile = savfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyzeCodeCM readFileDat(String datfile) {
        AnalyzeCodeCM retval = null;
        File file = new File(datfile);
        if (!file.exists()) {
            return null;
        }
        RandomAccessFile fis = null;
        try {
            fis = new RandomAccessFile(file, "r");
            if (fis.length() <= 0L) {
                fis.close();
                AnalyzeCodeCM analyzeCodeCM = null;
                return analyzeCodeCM;
            }
            Readfileout out = AnalyzeCodeCM.readFile(0L, fis);
            retval = (AnalyzeCodeCM)AnalyzeCodeCM.getObj(out.buff);
            out = AnalyzeCodeCM.readFile(out.seekpoint, fis);
            filedatas = (HashMap)AnalyzeCodeCM.getObj(out.buff);
            out = AnalyzeCodeCM.readFile(out.seekpoint, fis);
            funclist = (HashMap)AnalyzeCodeCM.getObj(out.buff);
        }
        catch (Exception e) {
            System.out.print("\u30d5\u30a1\u30a4\u30eb" + savfile + "\u30a2\u30af\u30bb\u30b9\u30a8\u30e9\u30fc\n" + e.toString());
            StackTraceElement[] ste = e.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                System.out.print(ste[i] + "\n");
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {}
        }
        return retval;
    }

    private static Object getObj(byte[] ba) {
        try {
            ByteArrayInputStream bia = new ByteArrayInputStream(ba);
            ObjectInputStream ois = new ObjectInputStream(bia);
            Object retval = ois.readObject();
            bia.close();
            ois.close();
            return retval;
        }
        catch (Exception e) {
            throw new Error("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5909\u63db\u30a8\u30e9\u30fc" + e.toString());
        }
    }

    private static Readfileout readFile(long seekpoint, RandomAccessFile fis) {
        try {
            fis.seek(seekpoint);
            short seg = fis.readShort();
            fis.seek(seekpoint += 2L);
            int leng = fis.readInt();
            fis.seek(seekpoint += 16L);
            byte[] buff = new byte[leng];
            fis.read(buff);
            return new Readfileout(seekpoint += (long)leng, buff);
        }
        catch (Exception e) {
            throw new Error("error file read \n" + e.toString());
        }
    }

    public void closeProcess() {
        AnalyzeCodeCM.saveFileDat(savfile, this);
    }

    public static void saveFileDat(String savfile, AnalyzeCodeCM savobj) {
        File file = new File(savfile);
        boolean crenew = !file.exists();
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rwd");
            FileChannel fcl = raf.getChannel();
            fcl.lock();
            byte[] ba = AnalyzeCodeCM.getBA(savobj);
            long seekpoint = 0L;
            seekpoint = AnalyzeCodeCM.witeFile(seekpoint, raf, ba);
            ba = AnalyzeCodeCM.getBA(filedatas);
            seekpoint = AnalyzeCodeCM.witeFile(seekpoint, raf, ba);
            ba = AnalyzeCodeCM.getBA(funclist);
            seekpoint = AnalyzeCodeCM.witeFile(seekpoint, raf, ba);
            raf.close();
        }
        catch (Exception e) {
            throw new Error("\u30d5\u30a1\u30a4\u30eb" + savfile + "\u30a2\u30af\u30bb\u30b9\u30a8\u30e9\u30fc\n" + e.toString());
        }
    }

    private static byte[] getBA(Object savobj) {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(boa);
            oos.writeObject(savobj);
            boa.flush();
            byte[] ba = boa.toByteArray();
            boa.close();
            oos.close();
            return ba;
        }
        catch (Exception e) {
            throw new Error("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u5909\u63db\u30a8\u30e9\u30fc" + e.toString());
        }
    }

    private static long witeFile(long seekpoint, RandomAccessFile raf, byte[] buff) {
        try {
            raf.seek(seekpoint);
            raf.writeShort(61680);
            raf.seek(seekpoint += 2L);
            raf.writeInt(buff.length);
            raf.seek(seekpoint += 16L);
            raf.write(buff);
            return seekpoint += (long)buff.length;
        }
        catch (Exception e) {
            throw new Error("\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\n" + e.toString());
        }
    }

    public void creData(File file) {
        ProcessKakko o = filedatas.get(file.getName());
        if (o != null) {
            return;
        }
        this.pathdir = file.getParent();
        this.cfile = this.erlfile = file.getName();
        String[] out = this.erlfile.split("\\.");
        this.modname = out.length == 0 ? this.erlfile : out[0];
        SpsTranzaction trans = AnalyzeCodeCM.creSpsTrans(file, this.modname);
        trans.first();
        while (trans.hasNext()) {
            trans.next();
        }
        ProcessKakko pk = trans.getTop();
        StringBuffer delog = new StringBuffer();
        delog.append("---AnalyzeCodeCM---\n");
        delog.append(pk.toLog() + "\n");
        ProcessKakko[] chlds = pk.getChildPks();
        for (int i = 0; i < chlds.length; ++i) {
            delog.append(chlds[i].toLog() + "\n");
        }
        AnalyzeCodeCM.logwriter(DBGLOGFILE1, delog.toString());
        filedatas.put(this.cfile, pk);
        this.addFuncList(pk);
        pk.setPath(this.pathdir);
    }

    private static SpsTranzaction creSpsTrans(File file, String modname) {
        WRwSplitTr wstr = new WRwSplitTr(1, file);
        return AnalyzeCodeCM.creSpsTrans(wstr, modname);
    }

    private static SpsTranzaction creSpsTrans(WRwSplitTr wstr, String modname) {
        WRwSplitChars wsc = new WRwSplitChars(wstr);
        wsc.creSps();
        ArrayList<SentPart> spsao = wsc.getSps();
        ArrayList<SentPart> spsaonew = AnalyzeCodeCM.modSps(spsao);
        SpsTranzaction trans = new SpsTranzaction(spsaonew, modname);
        return trans;
    }

    private static ArrayList<SentPart> modSps(ArrayList<SentPart> spsao) {
        ArrayList<SentPart> retval = new ArrayList<SentPart>();
        for (int i = 0; i < spsao.size(); ++i) {
            int j;
            String conj;
            SentPart sp = spsao.get(i);
            if ((sp.word == null || sp.word.equals("")) && ((conj = sp.getConjunc()) == null || conj.equals("") || conj.equals(" ") || conj.equals("\n"))) continue;
            SentPart[] sps2 = WRwSplitChars.splitWordchar(1, sp);
            if (sps2 != null) {
                for (j = 0; j < sps2.length; ++j) {
                    retval.add(sps2[j]);
                }
                continue;
            }
            if (WordSystemRev.isSysWord(spsao, i)) {
                wordsys.addExtCsWord(spsao, i);
            }
            if ((sps2 = wordsys.getRepSps(spsao, i)) != null) {
                for (j = 0; j < sps2.length; ++j) {
                    retval.add(sps2[j]);
                }
                continue;
            }
            retval.add(sp);
        }
        return retval;
    }

    public static Function getFuncData(String fname) {
        Function reged = funclist.get(fname);
        return reged;
    }

    public static boolean addFunc(String func, int parasize) {
        Function out = AnalyzeCodeCM.getFuncData(func);
        if (out != null) {
            return false;
        }
        Function add = new Function(func, parasize);
        funclist.put(func, add);
        return true;
    }

    private void addFuncList(ProcessKakko top) {
        String[] flist = top.getChildList();
        for (int i = 0; i < flist.length; ++i) {
            ProcessKakko child = top.getChild(flist[i]);
            Function reged = AnalyzeCodeCM.getFuncData(flist[i]);
            if (reged == null) {
                Function addf = new Function(top.getModname(), child);
                funclist.put(child.getScopname(), addf);
                continue;
            }
            if (reged.getPk() != null) continue;
            reged.setPk(top.getModname(), child);
        }
    }

    public void putErlsource(String fileName, String inlog) {
        try {
            if (this.pathdir == null || this.erlfile == null) {
                return;
            }
            FileWriter fileHandler = new FileWriter(fileName);
            BufferedWriter bufferHandler = new BufferedWriter(fileHandler);
            bufferHandler.write(inlog);
            bufferHandler.close();
            fileHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void logwriter(String filepath, String inlog) {
        try {
            if (filepath == null || inlog == null) {
                return;
            }
            String fileName = filepath;
            FileWriter fileHandler = new FileWriter(fileName, true);
            BufferedWriter bufferHandler = new BufferedWriter(fileHandler);
            bufferHandler.write(inlog);
            bufferHandler.close();
            fileHandler.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static SpsTranzaction forTestInstaceS(String in) {
        new AnalyzeCodeCM(false);
        char[] inchas = in.toCharArray();
        WRwSplitTr catr = new WRwSplitTr(1, inchas);
        SpsTranzaction trans = AnalyzeCodeCM.creSpsTrans(catr, "test");
        return trans;
    }

    public static ProcessKakko forTestInstace(String in) {
        SpsTranzaction trans = AnalyzeCodeCM.forTestInstaceS(in);
        trans.first();
        while (trans.hasNext()) {
            trans.next();
        }
        ProcessKakko pk = trans.getTop();
        return pk;
    }

    static {
        AUTO_SMP = true;
        wordsys = new WordSystemRev();
        savfile = "filedata.dat";
    }

    private static class Readfileout {
        private long seekpoint;
        private byte[] buff;

        private Readfileout(long sp, byte[] bu) {
            this.seekpoint = sp;
            this.buff = bu;
        }
    }
}

