/*
	NEC PC-8201 Emulator 'ePC-8201'

	Author : Takeda.Toshiya
	Date   : 2009.03.31-

	[ memory ]
*/

#ifndef _PC8201_MEMORY_H_
#define _PC8201_MEMORY_H_

#include "../vm.h"
#include "../../emu.h"
#include "../device.h"

namespace PC8201 {

class MEMORY : public DEVICE
{
private:
	DEVICE *d_cmt, *d_drec, *d_rtc;
	
	uint8_t ipl[0x8000];	// rom #0
	uint8_t ext[0x8000];	// rom #1
	uint8_t ram[0x8000*3];	// standard and optional ram
	uint8_t wdmy[0x1000];
	uint8_t rdmy[0x1000];
	uint8_t* wbank[16];
	uint8_t* rbank[16];
	
	uint8_t sio, bank;
	void update_bank();
	
public:
	MEMORY(VM_TEMPLATE* parent_vm, EMU* parent_emu) : DEVICE(parent_vm, parent_emu)
	{
		set_device_name(_T("Memory Bus"));
	}
	~MEMORY() {}
	
	// common functions
	void initialize();
	void release();
	void reset();
	void __FASTCALL write_data8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_data8(uint32_t addr);
	void __FASTCALL write_io8(uint32_t addr, uint32_t data);
	uint32_t __FASTCALL read_io8(uint32_t addr);
	bool process_state(FILEIO* state_fio, bool loading);
	
	// unique functions
	void set_context_cmt(DEVICE* device)
	{
		d_cmt = device;
	}
	void set_context_drec(DEVICE* device)
	{
		d_drec = device;
	}
	void set_context_rtc(DEVICE* device)
	{
		d_rtc = device;
	}
};

}
#endif

