// http://www.dinop.com/vc/service_ctrl.html (ja)

#pragma once

#include <winsvc.h>
#include "atlstr.h"

class	CDnpService
{
	//
	//	T[rX̋N^~pXbhNX
	//
	class CServiceThread
	{
	public:
		CServiceThread()
		{
			_bCancel = false;
		}

	private:

		bool					_bCancel;			//T[rX̋N^~fpϐAtrueȂ璆fJn
		CComAutoCriticalSection	_secbCancel;		//T[rX̋N^~fpNeBJZNV

	public:

		//
		//	T[rX̋N^~fp֐
		//
		//	fꍇIsCancel(true,true)Ăяo
		//
		bool	IsCancel(bool bSave=false,bool bNewValue=false)
		{
			bool	ret;

			_secbCancel.Lock();
				if(bSave)
				{
					_bCancel = bNewValue;
					ret = true;
				}
				else
					ret = _bCancel;
			_secbCancel.Unlock();

			return	ret;
		}



		//
		//	T[rX̊ȈՃRg[
		//
		//	̂܂܌ĂяoƃT[rXN^~܂Ŗ[vőҋ@B
		//	XbhŌĂяoAIsCancel()𗘗p邱ƂŖ[vɊׂȂ
		//	Rg[\B
		//
		bool	EasyStartStop(LPCTSTR pszName,bool bStart)
		{
			bool			ret;
			BOOL			bRet;
			SC_HANDLE		hManager;
			SC_HANDLE		hService;
			SERVICE_STATUS	sStatus;

			ret = false;
			hManager = NULL;
			hService = NULL;
			while(1)			//[vł͂ȂI
			{
				hManager = ::OpenSCManager(NULL,NULL,GENERIC_EXECUTE);
				if(hManager == NULL)
					break;

				if(bStart)
					hService = ::OpenService(hManager,pszName,SERVICE_START | SERVICE_QUERY_STATUS);
				else
					hService = ::OpenService(hManager,pszName,SERVICE_STOP | SERVICE_QUERY_STATUS);
				if(hService == NULL)
					break;

				::ZeroMemory(&sStatus,sizeof(SERVICE_STATUS));
				bRet = ::QueryServiceStatus(hService,&sStatus);
				if(bRet == FALSE)
					break;

				if(bStart && sStatus.dwCurrentState == SERVICE_RUNNING)
				{
					//ɃT[rX͓Ă
					ret = true;
					break;
				}
				if((bStart == false) && sStatus.dwCurrentState == SERVICE_STOPPED)
				{
					//ɃT[rX͎~܂Ă
					ret = true;
					break;
				}

				CString cstr;
				cstr.Format(_T("sStatus.dwCurrentState:%08X"), sStatus.dwCurrentState);
				DebugPrint(cstr);

				if(bStart)
				{
					////////////////////////////
					//	T[rXJn
					//

					if(sStatus.dwCurrentState == SERVICE_STOPPED)
					{
						//T[rXJnv
						DebugPrint(_T("StartService"));
						bRet = ::StartService(hService,NULL,NULL);
						// ERROR_ALREADY_EXISTS
						/*
						if(bRet == FALSE)
						{
							cstr.Format(_T("%08X"), GetLastError());
							DebugPrint(_T("NG:StartService"));
							DebugPrint(cstr);
							break;
						}
						else
						{
							DebugPrint(_T("OK:StartService"));
						}
						*/

						//Jn܂Ŗ[vőҋ@
						//IsCancel𗘗pΖ[v̒Eo\
						DebugPrint(_T("QueryServiceStatus"));
						int count = 0;
						while(::QueryServiceStatus(hService,&sStatus))
						{
							// [v (ő 5 b WMI ̏҂)
							if(count >= 10)
							{
								break;
							}

							if(sStatus.dwCurrentState == SERVICE_RUNNING)
							{
								ret = true;
								break;
							}
							DebugPrint(_T("sStatus.dwCurrentState != SERVICE_RUNNING"));

							if(IsCancel())
								break;

							::Sleep(500);
							DebugPrint(_T("Sleep"));
							count++;
							continue;
						}
						cstr.Format(_T("GetLastError():%08X"), GetLastError());
						DebugPrint(cstr);
					}
					break;
				}


				////////////////////////////
				//	T[rX~
				//

				if(sStatus.dwCurrentState == SERVICE_RUNNING)
				{
					//T[rX~v
					bRet = ::ControlService(hService,SERVICE_CONTROL_STOP,&sStatus);
					/*
					if(bRet == FALSE)
						break;
					*/

					//~܂Ŗ[vőҋ@
					//IsCancel𗘗pΖ[v̒Eo\
					while(::QueryServiceStatus(hService,&sStatus))
					{
						if(sStatus.dwCurrentState == SERVICE_STOPPED)
						{
							ret = true;
							break;
						}

						if(IsCancel())
							break;

						//::Sleep(sStatus.dwWaitHint);
						//{ȂdwWaitHitSleep邪Af邽
						//500msecSleep
						::Sleep((sStatus.dwWaitHint > 500) ? 500 : sStatus.dwWaitHint);
						continue;
					}
				}

				break;		//K{I̍sȂƖ[vɂȂ邩
			}

			DebugPrint(_T("EasyStartStop"));
			//ATLASSERT(ret);

			if(hService)
				::CloseServiceHandle(hService);
			if(hManager)
				::CloseServiceHandle(hManager);

			return	ret;
		}
	};


public:


	//
	//	T[rX̊ȈՃRg[
	//
	//	T[rXN/~܂Ŗ[vőҋ@B
	//
	bool	EasyStartStop(LPCTSTR pszName,bool bStart)
	{
		CServiceThread	cThread;

		return	cThread.EasyStartStop(pszName,bStart);
	}


	//
	//	T[rX̊ȈՋN
	//
	//	T[rXN܂Ŗ[vőҋ@B
	//
	bool	EasyStart(LPCTSTR pszName)
	{
		return	EasyStartStop(pszName,true);
	}

	//
	//	T[rX̊ȈՒ~
	//
	//	T[rX~܂Ŗ[vőҋ@B
	//
	bool	EasyStop(LPCTSTR pszName)
	{
		return	EasyStartStop(pszName,false);
	}


	//
	//	T[rX̊ȈՍċN
	//
	//	T[rXċN܂Ŗ[vőҋ@B
	//
	bool	EasyRestart(LPCTSTR pszName)
	{
		bool			ret;
		CServiceThread	cThread;

		ret = cThread.EasyStartStop(pszName,false);
		if(ret)
			ret = cThread.EasyStartStop(pszName,true);

		return	ret;
	}



	//
	//	w肷T[rXĂ邩̃`FbN
	//
	//	falsȅꍇ"~"Ƃ͌ȂBT[rX݂ȂꍇȂǂfalseƂȂB
	//
	bool	IsServiceRunning(LPCTSTR pszName)
	{
		bool			ret;
		BOOL			bRet;
		SC_HANDLE		hManager;
		SC_HANDLE		hService;
		SERVICE_STATUS	sStatus;

		ret = false;
		hManager = NULL;
		hService = NULL;
		while(1)			//[vł͂ȂI
		{
			hManager = ::OpenSCManager(NULL,NULL,GENERIC_EXECUTE);
			ATLASSERT(hManager);
			if(hManager == NULL)
				break;

			hService = ::OpenService(hManager,pszName,SERVICE_QUERY_STATUS);
			ATLASSERT(hService);
			if(hService == NULL)
				break;

			::ZeroMemory(&sStatus,sizeof(SERVICE_STATUS));
			bRet = ::QueryServiceStatus(hService,&sStatus);
			ATLASSERT(bRet);
			if(bRet == FALSE)
				break;

			if(sStatus.dwCurrentState == SERVICE_RUNNING)
				ret = true;

			break;		//K{
		}

		if(hService)
			::CloseServiceHandle(hService);
		if(hManager)
			::CloseServiceHandle(hManager);

		return	ret;
	}
};
