(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit KeyDataUnit;

interface

uses
  SysUtils;

type
  TKey = array of Byte;

  TKeyData = class
  private
    FData: array of array of Byte;
  protected
    function GetData(I, J: Integer): Byte;
    procedure SetData(I, J: Integer; Value: Byte);
    function GetKey(I: Integer): TKey;
    function GetNumKey: Integer;
    procedure SetNumKey(Value: Integer);
    function GetKeyLen(I: Integer): Integer;
    procedure SetKeyLen(I, Value: Integer);
  public
    constructor Create;
    procedure Clear;
    property Data[I, J: Integer]: Byte read GetData write SetData; default;
    property Key[I: Integer]: TKey read GetKey;
    property NumKey: Integer read GetNumKey write SetNumKey;
    property KeyLen[I: Integer]: Integer read GetKeyLen write SetKeyLen; 
  end;

implementation

constructor TKeyData.Create;
begin
  inherited;
  SetLength(FData, 0, 0);
end;

procedure TKeyData.Clear;
begin
  SetLength(FData, 0, 0);
end;

function TKeyData.GetData(I, J: Integer): Byte;
begin
  Result := FData[I, J];
end;

procedure TKeyData.SetData(I, J: Integer; Value: Byte);
begin
  FData[I, J] := Value;
end;

function TKeyData.GetKey(I: Integer): TKey;
var
  N: Integer;
begin
  SetLength(Result, KeyLen[I]);
  for N := 0 to High(Result) do
    Result[N] := Data[I, N];
end;

function TKeyData.GetNumKey: Integer;
begin
  Result := Length(FData);
end;

procedure TKeyData.SetNumKey(Value: Integer);
var
  I: Integer;
begin
  SetLength(FData, Value, 0);
  for I := 0 to High(FData) do
    SetKeyLen(I, 0);
end;

function TKeyData.GetKeyLen(I: Integer): Integer;
begin
  Result := Length(FData[I]);
end;

procedure TKeyData.SetKeyLen(I, Value: Integer);
var
  N: Integer;
begin
  SetLength(FData[I], Value);
  for N := 0 to High(FData[I]) do
    FData[I, N] := 0;
end;

end.
