(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobO.
 *
 * ÍobO is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobO is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit MainFormUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Menus, Buttons, gcryptUnit, KeyUnit,
  PacketUnit, ActnList;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    StatusBar: TStatusBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadLockedBagMenu: TMenuItem;
    N1: TMenuItem;
    ExitMenu: TMenuItem;
    Help1: TMenuItem;
    AboutMenu: TMenuItem;
    ExitButton: TButton;
    DecryptButton: TSpeedButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    Image1: TImage;
    Label4: TLabel;
    Label1: TLabel;
    FileNameLabel: TLabel;
    ActionList: TActionList;
    ExitAction: TAction;
    AboutAction: TAction;
    LoadLockedBagAction: TAction;
    DecryptAction: TAction;
    Bevel3: TBevel;
    KeyIDLabel: TLabel;
    procedure ExitActionExecute(Sender: TObject);
    procedure AboutActionExecute(Sender: TObject);
    procedure LoadLockedBagActionExecute(Sender: TObject);
    procedure DecryptActionExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
    FLoadFile: Boolean;
    FFileName: string;
    FEncMDC: TPubKeyEncSessKeyPacket;
  protected
    procedure LoadBag(FileName: string);
    procedure SetLoadFile(Value: Boolean);
    procedure OnDecryptTerminate(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property LoadFile: Boolean read FLoadFile write SetLoadFile;
  end;

var
  MainForm: TMainForm;

implementation

uses
  PacketIOUnit, InputPasswdFormUnit, AboutFormUnit, DecryptFormUnit,
  DecryptThreadUnit, InputTextFormUnit;

{$R *.dfm}

procedure TMainForm.LoadBag(FileName: string);
var
  I: TFileStream;
  PIO: TPacketIO;
begin
  try
    I := TFileStream.Create(FileName, fmOpenRead or fmShareExclusive);
    try
      PIO := TPacketIO.Create;
      try
        PIO.Load(I, FEncMDC);

        FFileName := FileName;
        LoadFile := True;
      finally
        PIO.Free;
      end;
    finally
      I.Free;
    end;
  except
    on E: Exception do
      MessageDlg('bNꂽÍobO̓ǂݍ݂ŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0);
    else
      MessageDlg('bNꂽÍobO̓ǂݍ݂ŃG[܂', mtError, [mbAbort], 0);
  end;
end;

procedure TMainForm.SetLoadFile(Value: Boolean);
begin
  FLoadFile := Value;

  DecryptButton.Enabled := FLoadFile;

  if FLoadFile then
  begin
    FileNameLabel.Caption := ExtractFileName(FFileName);
    KeyIDLabel.Caption    := FEncMDC.StrKeyID;
    StatusBar.SimpleText  := '';
  end;
end;

procedure TMainForm.OnDecryptTerminate(Sender: TObject);
var
  E: Exception;
begin
  if not (Sender is TThread) then
    Exit;

  if TThread(Sender).FatalException is Exception then
  begin
    E := Exception(TThread(Sender).FatalException);
    MessageDlg('ÍǏŃG[܂' + #13 + E.Message, mtError, [mbAbort], 0);
  end;
end;

constructor TMainForm.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  gcry_control(GCRYCTL_INIT_SECMEM, 16384, 0);

  LoadFile := False;
  FFileName := '';
  FEncMDC   := TPubKeyEncSessKeyPacket.Create;
end;

destructor TMainForm.Destroy;
begin
  FEncMDC.Free;
  inherited;
end;

procedure TMainForm.ExitActionExecute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.AboutActionExecute(Sender: TObject);
var
  DLG: TAboutForm;
begin
  DLG := TAboutForm.Create(Self);
  try
    DLG.ShowModal;
  finally
    DLG.Free;
  end;
end;

procedure TMainForm.LoadLockedBagActionExecute(Sender: TObject);
begin
  OpenDialog.Title    := 'bNꂽÍobOJ';
  OPenDialog.FileName := '';
  OpenDialog.Filter   := 'bNꂽÍobO (*.cblbg)|*.cblbg';
  OpenDialog.Options  := [ofHideReadOnly, ofFileMustExist, ofDontAddToRecent];

  if OpenDialog.Execute then
    LoadBag(OpenDialog.FileName);
end;

procedure TMainForm.DecryptActionExecute(Sender: TObject);
var
  I: TFileStream;
  SecKey: TSecKey;
  LH : TLiteralPacketHeader;
  PW: string;
  PasswdDLG: TInputPasswdForm;
  DT: TDecryptThread;
  DecryptDLG: TDecryptForm;
  TextDLG: TInputTextForm;
begin
  OpenDialog.Title    := 'bNÍL[J';
  OpenDialog.FileName := '';
  OpenDialog.Filter   := 'ÍL[ (*.cbkey)|*.cbkey';
  OpenDialog.Options  := [ofHideReadOnly, ofFileMustExist, ofDontAddToRecent];

  if not OpenDialog.Execute then
    Exit;

  try
    SecKey := TSecKey.Create;
    try
      I := TFileStream.Create(OpenDialog.FileName, fmOpenRead or fmShareExclusive);
      try
        SecKey.LoadFromStream(I);
      finally
        I.Free;
      end;

      while SecKey.IsLocked do
      begin
        PasswdDLG := TInputPasswdForm.Create(Self);
        try
          if PasswdDLG.ShowModal <> mrOK then
            Exit;

          PW := PasswdDLG.PasswdEdit.Text;

          if not SecKey.Unlock(PW) then
            if MessageDlg('ÍL[̃pX[hႢ܂', mtError, [mbRetry, mbCancel], 0) <> IDRETRY then
              Exit;
        finally
          PasswdDLG.Free;
        end;
      end;

      LH := TLiteralPacketHeader.Create;
      try
        I := TFileStream.Create(FFileName, fmOpenRead or fmShareExclusive);
        try
          SecKey.DecodeFileHeader(I, LH);
        finally
          I.Free;
        end;

        if (LH.FileName = '_CONSOLE') and (LH.Mode = FILE_MODE_TEXT) then
        begin
          SecKey.Lock(PW);
          TextDLG := TInputTextForm.Create(Self);
          TextDLG.Caption := 'ÍĂeLXg';
          TextDLG.OKButton.Visible := False;
          TextDLG.CancelButton.Caption := '(&C)';
          TextDLG.Memo.ReadOnly := True;
          try
            DecryptDLG := TDecryptForm.Create(Self);
            try
              DT := TDecryptThread.Create(True, SecKey, PW, FFileName, TextDLG, DecryptDLG);
              DT.FreeOnTerminate := True;
              DT.OnTerminate := OnDecryptTerminate;
              DT.Resume;

              DecryptDLG.ShowModal;
            finally
              DecryptDLG.Free;
            end;
            TextDLG.ShowModal;
          finally
            TextDLG.Free;
          end;
        end
        else
        begin
          SaveDialog.Title    := 'ot@CZ[u';
          SaveDialog.Filter   := 't@C (*.*)|*.*';
          SaveDialog.FileName := ExtractFilePath(FFileName) + LH.FileName;
          SaveDialog.Options  := [ofHideReadOnly, ofOverwritePrompt, ofDontAddToRecent];

          if not SaveDialog.Execute then
            Exit;

          SecKey.Lock(PW);
          DecryptDLG := TDecryptForm.Create(Self);
          try
            DT := TDecryptThread.Create(True, SecKey, PW, FFileName, SaveDialog.FileName, DecryptDLG);
            DT.FreeOnTerminate := True;
            DT.OnTerminate := OnDecryptTerminate;
            DT.Resume;

            DecryptDLG.ShowModal;
          finally
            DecryptDLG.Free;
          end;
        end;
      finally
        LH.Free;
      end;
    finally
      SecKey.Free;
    end;
  except
    on E: Exception do
      MessageDlg('bN̉ŃG[܂' + #13 + E.Message, mtError, [mbOK], 0);
    else
      MessageDlg('bN̉ŃG[܂', mtError, [mbOK], 0);
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FileNameLabel.Caption := '';
  KeyIDLabel.Caption    := '';
  StatusBar.SimpleText  := 'bNꂽÍobOǂݍ܂Ă܂';
  DecryptButton.Enabled := False;

  if ParamStr(1) <> '' then
    LoadBag(ParamStr(1));
end;

end.
