(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit zlibUnit;

interface

const
  ZLIB_VERSION = '1.1.4';

type
  voidpf = Pointer;
  int    = Integer;
  uInt   = Cardinal;
  pBytef = PChar;
  uLong  = Cardinal;

  alloc_func = function(opaque: voidpf; items, size: uInt): voidpf; stdcall;
  free_func  = procedure(opaque, address: voidpf); stdcall;

  internal_state = Pointer;

  z_streamp = ^z_stream;
  z_stream = packed record
    next_in: pBytef;          // next input byte
    avail_in: uInt;           // number of bytes available at next_in
    total_in: uLong;          // total nb of input bytes read so far

    next_out: pBytef;         // next output byte should be put there
    avail_out: uInt;          // remaining free space at next_out
    total_out: uLong;         // total nb of bytes output so far

    msg: PChar;               // last error message, NULL if no error
    state: internal_state;    // not visible by applications

    zalloc: alloc_func;       // used to allocate the internal state
    zfree: free_func;         // used to free the internal state
    opaque: voidpf;           // private data object passed to zalloc and zfree

    data_type: int;           // best guess about the data type: ascii or binary
    adler: uLong;             // adler32 value of the uncompressed data
    reserved: uLong;          // reserved for future use
    end;

const
  Z_NO_FLUSH   = 0;
  Z_SYNC_FLUSH = 2;
  Z_FULL_FLUSH = 3;
  Z_FINISH     = 4;

  Z_OK         = 0;
  Z_STREAM_END = 1;

  Z_NO_COMPRESSION      =  0;
  Z_BEST_SPEED          =  1;
  Z_BEST_COMPRESSION    =  9;
  Z_DEFAULT_COMPRESSION = -1;

  Z_FILTERED            = 1;
  Z_HUFFMAN_ONLY        = 2;
  Z_DEFAULT_STRATEGY    = 0;

  Z_BINARY  = 0;
  Z_ASCII   = 1;
  Z_UNKNOWN = 2;

  Z_DEFLATED = 8;

  MAX_MEM_LEVEL = 9;

function adler32(adler: uLong; const buf: pBytef; len: uInt): uLong; stdcall;
function crc32(crc: uLong; const buf: pBytef; len: uInt): uLong; stdcall;
function deflate(strm: z_streamp; flush: int): int; stdcall;
function deflateCopy(dest, source: z_streamp): int; stdcall;
function deflateEnd(strm: z_streamp): int; stdcall;
function deflateInit2_(strm: z_streamp; level, method, windowBits, memLevel, strategy: int; const version: PChar; stream_size: int): int; stdcall;
function deflateInit_(strm: z_streamp; level: int; const version: PChar; stream_size: int): int; stdcall;
function deflateParams(strm: z_streamp; level, strategy: int): int; stdcall;
function deflateReset(strm: z_streamp): int; stdcall;
function deflateSetDictionary(strm: z_streamp; const dictionary: pBytef; dictLength: uInt): int; stdcall;
function inflate(strm: z_streamp; flush: int): int; stdcall;
function inflateEnd(strm: z_streamp): int; stdcall;
function inflateInit2_(strm: z_streamp; windowBits: int; const version: PChar; stream_size: int): int; stdcall;
function inflateInit_(strm: z_streamp; const version: PChar; stream_size: int): int; stdcall;
function inflateReset(strm: z_streamp): int; stdcall;
function inflateSetDictionary(strm: z_streamp; const dictionary: pBytef; dictLength: uInt): int; stdcall;
function inflateSync(strm: z_streamp): int; stdcall;

function deflateInit(strm: z_streamp; level: int): int;
function deflateInit2(strm: z_streamp; level, method, windowBits, memLevel, strategy: int): int;
function inflateInit(strm: z_streamp): int;
function inflateInit2(strm: z_streamp; windowBits: int): int;

implementation

function deflateInit(strm: z_streamp; level: int): int;
begin
  Result := deflateInit_(strm, level, ZLIB_VERSION, sizeof(z_stream));
end;

function deflateInit2(strm: z_streamp; level, method, windowBits, memLevel, strategy: int): int;
begin
  Result := deflateInit2_(strm, level, method, windowBits, memLevel, strategy, ZLIB_VERSION, sizeof(z_stream));
end;

function inflateInit(strm: z_streamp): int;
begin
  Result := inflateInit_(strm, ZLIB_VERSION, sizeof(z_stream));
end;

function inflateInit2(strm: z_streamp; windowBits: int): int;
begin
  Result := inflateInit2_(strm, windowBits, ZLIB_VERSION, sizeof(z_stream));
end;

function adler32; external 'zlib.dll';
function crc32; external 'zlib.dll';
function deflate; external 'zlib.dll';
function deflateCopy; external 'zlib.dll';
function deflateEnd; external 'zlib.dll';
function deflateInit2_; external 'zlib.dll';
function deflateInit_; external 'zlib.dll';
function deflateParams; external 'zlib.dll';
function deflateReset; external 'zlib.dll';
function deflateSetDictionary; external 'zlib.dll';
function inflate; external 'zlib.dll';
function inflateEnd; external 'zlib.dll';
function inflateInit2_; external 'zlib.dll';
function inflateInit_; external 'zlib.dll';
function inflateReset; external 'zlib.dll';
function inflateSetDictionary; external 'zlib.dll';
function inflateSync; external 'zlib.dll';

end.
