(*
 * Copyright (C) 2002 Jun Kikuchi <kikuchi@bonnou.com>
 *
 * This file is part of ÍobN.
 *
 * ÍobN is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * ÍobN is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)
unit EncryptThreadUnit;

interface

uses
  Classes, SysUtils, ComCtrls, KeyUnit, EncryptFormUnit;

type
  TEncryptThread = class(TThread)
  private
    { Private 錾 }
    FPubKey: TPubKey;
    FInFileName,
    FOutFileName: string;
    FInStream,
    FOutStream: TStream;
    FForm: TEncryptForm;
  protected
    procedure Execute; override;
    procedure OnProgress(Sender: TObject);
    procedure UpdateForm;
  public
    constructor Create(CreateSuspended: Boolean; PubKey: TPubKey; InFileName, OutFileName: string; Form: TEncryptForm); overload;
    constructor Create(CreateSuspended: Boolean; PubKey: TPubKey; InLines: TStrings; OutFileName: string; Form: TEncryptForm); overload;
    destructor Destroy; override;
  end;

implementation

{:
  قȂXbhL VCL ܂ CLX ̃\bh/֐/
  vpeBʂ̃Xbh̒爵ꍇAr̖肪
  ܂B

  CXbh̏LIuWFNgɑ΂Ă Synchronize
  \bhgł܂B̃IuWFNgQƂ邽
  ̃\bhXbhNXɒǉASynchronize \bh
  Ƃēn܂B

  Ƃ΁AUpdateCaption \bhȉ̂悤ɒ`A

    procedure TEncryptThread.UpdateCaption;
    begin
      Form1.Caption := 'TEncryptThread Xbh珑܂';
    end;

  Execute \bh̒ Synchronize \bhɓnƂŃC
  XbhL Form1  Caption vpeBSɕ
  Xł܂B

      Synchronize(UpdateCaption);
}

{ TEncryptThread }

procedure TEncryptThread.Execute;
var
  LH: TLiteralPacketHeader;
begin
  { ToDo : XbhƂĎsR[h̉ɋLqĂ }
  LH := TLiteralPacketHeader.Create;
  try
    if FInFileName = '_CONSOLE' then
      LH.Mode := FILE_MODE_TEXT
    else
      LH.Mode := FILE_MODE_BIN;
    LH.FileName := ExtractFileName(FInFileName);
    LH.Date     := Now;

    FPubKey.OnProgress := OnProgress;
    FPubKey.EncodeFile(FInStream, FOutStream, LH);
  finally
    LH.Free;
  end;
end;

procedure TEncryptThread.OnProgress(Sender: TObject);
begin
  Synchronize(UpdateForm);
end;

procedure TEncryptThread.UpdateForm;
begin
  if FInStream.Position = FInStream.Size then
  begin
    FForm.FilePosLabel.Caption := 'I';
    FForm.ExitButton.Caption   := '(&C)';
  end
  else
  begin
    FForm.FilePosLabel.Caption := IntToStr(FInStream.Position) + ' oCgς';
  end;

  if FInStream.Size <> 0 then
    FForm.ProgressBar.Position := Trunc((FInStream.Position / FInStream.Size) * 100)
  else
    FForm.ProgressBar.Position := 100;
end;

constructor TEncryptThread.Create(CreateSuspended: Boolean; PubKey: TPubKey; InFileName, OutFileName: string; Form: TEncryptForm);
var
  MS: TMemoryStream;
begin
  inherited Create(CreateSuspended);

  FPubKey      := TPubKey.Create;
  FInFileName  := InFileName;
  FOutFileName := OutFileName;
  FInStream    := TFileStream.Create(FInFileName, fmOpenRead or fmShareExclusive);
  FOutStream   := TFileStream.Create(FOutFileName, fmCreate or fmShareExclusive);
  FForm        := Form;

  FForm.InFileNameLabel.Caption  := ExtractFileName(FInFileName);
  FForm.OutFileNameLabel.Caption := ExtractFileName(FOutFileName);
  FForm.FileSizeLabel.Caption := IntToStr(FInStream.Size) + ' oCg';
  FForm.FilePosLabel.Caption  := 'Í̏...';
  FForm.ExitButton.Caption    := '~(&A)';

  MS := TMemoryStream.Create;
  try
    PubKey.SaveToStream(MS);
    MS.Position := 0;
    FPubKey.LoadFromStream(MS);
  finally
    MS.Free;
  end;
end;

constructor TEncryptThread.Create(CreateSuspended: Boolean; PubKey: TPubKey; InLines: TStrings; OutFileName: string; Form: TEncryptForm);
var
  MS: TMemoryStream;
begin
  inherited Create(CreateSuspended);

  FPubKey      := TPubKey.Create;
  FInFileName  := '_CONSOLE';
  FOutFileName := OutFileName;
  FInStream    := TMemoryStream.Create;
  InLines.Text := UTF8Encode(InLines.Text);
  InLines.SaveToStream(FInStream);
  FInStream.Position := 0;
  FOutStream   := TFileStream.Create(FOutFileName, fmCreate or fmShareExclusive);
  FForm        := Form;

  FForm.InFileNameLabel.Caption  := ExtractFileName(FInFileName);
  FForm.OutFileNameLabel.Caption := ExtractFileName(FOutFileName);
  FForm.FileSizeLabel.Caption := IntToStr(FInStream.Size) + ' oCg';
  FForm.FilePosLabel.Caption  := 'Í̏...';
  FForm.ExitButton.Caption    := '~(&A)';

  MS := TMemoryStream.Create;
  try
    PubKey.SaveToStream(MS);
    MS.Position := 0;
    FPubKey.LoadFromStream(MS);
  finally
    MS.Free;
  end;
end;

destructor TEncryptThread.Destroy;
begin
  FOutStream.Free;
  FInStream.Free;
  FPubKey.Free;
  inherited;
end;

end.
