//-----------　以下のコードは必要のあるユーザのみ記述する --------------

// ユーザ独自のkeyPressed()
void userKeyPressed() {
  if ((key == 'q') || (key == 'Q')) crowbar.stop();
  // 何でも良いのでキーが押されたら処理を再開
  crowbar.loop();
}

class dataClass {
  float x, y;
  dataClass() {
    x = y = 0.0;
  }
}
class graphClass {
  float  Ymin, Ymax;
  float  Xmin, Xmax;
  float xa, xb, xc;
  float pixelRatio;
  int size;
  dataClass data[];
  boolean xbase;    // X軸を基準としたpixelRatioか？
  graphClass(int s) {
    Xmin = Xmax = 0.0;
    Ymin = Ymax = 0.0;
    size = s;
    data = new dataClass[100];
    int i;
    for (i = 0; i < size; i++) data[i] = new dataClass();
    xbase = true;
  }
  void calc(float ca, float cb) {
    int    i;
    float  x;
    xa = ca;
    xb = cb;
    xc = (xa + xb) / 2.0;
    // 全計算
    for (i = 0; i < size; i++) {
      x = xa + (xb - xa) / size * i;
      data[i].x = x;
      data[i].y = f(x);
    }
    // 最大値最小値（Y)を求める
    for (i = 0; i < size; i++) {
      if (i == 0) {
        Ymin = Ymax = data[i].y;
      } else {
        if (data[i].y < Ymin) Ymin = data[i].y;
        if (data[i].y > Ymax) Ymax = data[i].y;
      }
    }
    float xwidth, ywidth;
    xwidth = abs(xb - xa);
    ywidth = abs(Ymax - Ymin);
    Xmin = xa - xwidth * 2.0;
    Xmax = xb + xwidth * 2.0;
    Ymin -= ywidth * 0.05;
    Ymax += ywidth * 0.05;

//  if ((Xmin < 0) && (Xmax < 0)) Xmax = 0.0;
//  if ((Xmin > 0) && (Xmax > 0)) Xmin = 0.0;

    crowbar.view("Graph");
    crowbar.world(Xmin, Ymin, Xmax, Ymax);
  }
  void graphdraw() {
    int  i;
    crowbar.view("Graph");
    crowbar.cv.clrView();
    // ｘ軸を描画
    crowbar.cv.line(Xmin, 0, Xmax, 0);
    // ｙ軸を描画
    crowbar.cv.line(0.0, Ymax, 0.0, Ymin);
    // グラフを描画
    for (i = 0; i < size - 1; i++) {
      crowbar.cv.line(data[i].x, data[i].y, data[i+1].x, data[i+1].y);
    }
    // xaを描画
    crowbar.cv.dashedLine(xa, 0, xa, f(xa), 10);
    crowbar.cv.fill(#ff0000);
    crowbar.cv.ellipse(xa, f(xa), 10);
    crowbar.cv.fill(#000000);
    // xbを描画
    crowbar.cv.dashedLine(xb, 0, xb, f(xb), 10);
    crowbar.cv.fill(#0000ff);
    crowbar.cv.ellipse(xb, f(xb), 10);
    crowbar.cv.fill(#000000);
    // xcを描画
    crowbar.cv.dashedLine(xc, 0, xc, f(xc), 10);
    crowbar.cv.fill(#008000);
    crowbar.cv.ellipse(xc, f(xc), 10);

    // テキスト情報を描画
    crowbar.view("Text");
    crowbar.cv.clrView();
    int tx, ty, dy;
    tx = 15; ty = 15;
    dy = crowbar.cv.textLeading();
    crowbar.cv.viewTextColor(#000000);
    crowbar.cv._text(str(loopcount) + "回目", tx, ty);  ty += dy;
    crowbar.cv.viewTextColor(#ff0000);
    crowbar.cv._text("xa", tx, ty);
    crowbar.cv.viewTextColor(#000000);
    crowbar.cv._text(" = " + nf(xa, 1, 10) + " f(xa) = " + nf(f(xa), 1, 10));  ty += dy;
    crowbar.cv.viewTextColor(#008000);
    crowbar.cv._text("xc", tx, ty);
    crowbar.cv.viewTextColor(#000000);
    crowbar.cv._text(" = " + nf(xc, 1, 10) + " f(xc) = " + nf(f(xc), 1, 10)); ty += dy;
    crowbar.cv.viewTextColor(#0000ff);
    crowbar.cv._text("xb", tx, ty);
    crowbar.cv.viewTextColor(#000000);
    crowbar.cv._text(" = " + nf(xb, 1, 10) + " f(xb) = " + nf(f(xb), 1, 10)); ty += dy;
    crowbar.cv._text("(xb - xa) = " + nf(xb - xa, 1, 10), tx, ty); ty += dy;
    crowbar.cv._text("|f(xb) - f(xa)| = " + nf(abs(f(xb) - f(xa)), 1, 10), tx, ty);
  }
}

// もしMain()終了後に通常のProcessingのようにエンドレスに処理を続ける場合は
// setup()にcrowbar.nonStop()を記述すると共に，以下にコードを記述．
// ユーザ独自のdraw()
graphClass graph = new graphClass(100);
void userDraw() {
  crowbar.clrscr();
  // 繰り返し計算
  if (keyPressed && key == ' ') {
    c = (a + b) / 2.0;
    if (sgn(f(a)) == sgn(f(c))) a = c; else b = c;
    loopcount++;
  }
  // グラフ表示
  graph.calc(a, b);
  graph.graphdraw();
  // キーが押されるまで処理を中断
  crowbar.noLoop();
}

// もしMain()の開始前に実行しておきたいコードが別にある場合は以下に記述．
// このルーチンの出力はログファイルに記録されません．
void preMain() {
}

// もしMain()終了後に実行しておきたいコードが別にある場合は以下に記述．
// このルーチンの出力はログファイルに記録されません．
void postMain() {
}

// ユーザ独自のmousePressed()
void userMousePressed() {
}
// ユーザ独自のmouseRelased()
void userMouseReleased() {
}
// ユーザ独自のmouseDragged()
void userMouseDragged() {
}
// ユーザ独自のmouseMoved()
void userMouseMoved() {
}
// ユーザ独自のmouseClicked()
void userMouseClicked() {
}
// ユーザ独自のkeyRleased()
void userKeyReleased() {
}
// ユーザ独自のkeyTyped()
void userKyeTyped() {
}

