/*
 * MallocAllocatorTest.cpp
 */

#include "ContainersTest.h"
#include <debug/MallocAllocator.h>
#include <string>
#include <vector>
#include <list>
#include <deque>
#include <set>
#include <map>

dg_USING_NAMESPACE_STD

typedef basic_string<char, char_traits<char>, MallocAllocator<char> > String;

struct TestTraits
{
	typedef ::String String;
	typedef MallocAllocator<int> IntAlloc;
	typedef MallocAllocator<pair<const String, int> > PairAlloc;

	typedef vector  <int, IntAlloc> Vector;
	typedef list    <int, IntAlloc> List;
	typedef deque   <int, IntAlloc> Deque;
	typedef set     <int, less<int>, IntAlloc> Set;
	typedef multiset<int, less<int>, IntAlloc> Multiset;
	typedef map     <String, int, less<String>, PairAlloc> Map;
	typedef multimap<String, int, less<String>, PairAlloc> Multimap;
};

int main()
{
	ContainersTest<TestTraits>::testSeq();
	ContainersTest<TestTraits>::testSet();
	ContainersTest<TestTraits>::testMap();
	return 0;
}

// string ̃AP[^ύXꍇAȉ̋LqKvB
#ifdef __BORLANDC__
#  include <string.cc>
#endif
#ifdef VxWorks
#  include <std/bastring.cc>
String::Rep String::nilRep = { 0, 0, 1 };
#endif
