/*
 * LeakCheckerAllocator.h
 *
 * Copyright (C) 2001-2002 by Ito Yoshiichi.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef debug_LeakCheckerAllocator_h
#define debug_LeakCheckerAllocator_h

#include "dgconfig.h"
#include "LeakChecker.h"

#undef new

dg_NAMESPACE_BEGIN(debug)

/**
 * LeakChecker ΉAP[^B
 */
template <class T>
class LeakCheckerAllocator
{
  public:
	typedef T value_type;
	typedef size_t size_type;
	typedef ptrdiff_t difference_type;
	typedef value_type& reference;
	typedef const value_type& const_reference;
	typedef value_type* pointer;
	typedef const value_type* const_pointer;

	LeakCheckerAllocator() dg_NOTHROW {}
	template <class T2>
	LeakCheckerAllocator(const LeakCheckerAllocator<T2>&) dg_NOTHROW {}
	~LeakCheckerAllocator() dg_NOTHROW {}

	pointer address(reference x) const { return &x; }
	const_pointer address(const_reference x) const { return &x; }

	dg_ALLOCATOR_STATIC		// for GNU C
	pointer allocate(size_type n, const void* = 0)
		{ return (pointer)dg_malloc(n * sizeof(value_type), __FILE__, __LINE__); }
#ifdef dg_DEALLOCATE_NEEDS_VOID_PTR
	dg_ALLOCATOR_STATIC		// for GNU C
	void deallocate(void* p, size_type /* n */)
#else
	void deallocate(pointer p, size_type /* n */)
#endif
		{ dg_free(p, __FILE__, __LINE__); }

	void construct(pointer p, const value_type& value)
		{ new(p) value_type(value); }
	void destroy(pointer p) { p->~T(); }

	size_type max_size() const dg_NOTHROW
		{ return size_type(-1) / sizeof(value_type); }

#ifndef dg_NO_MEMBER_TEMPLATE_CLASSES
	template <class T2>
	struct rebind { typedef LeakCheckerAllocator<T2> other; };
#endif

#ifdef _MSC_VER
	char* _Charalloc(size_type n) { return (char*)allocate(n); }
#endif
};

template <class T>
inline bool operator==(
		const LeakCheckerAllocator<T>&, const LeakCheckerAllocator<T>&)
{
	return true;
}

template <class T>
inline bool operator!=(
		const LeakCheckerAllocator<T>&, const LeakCheckerAllocator<T>&)
{
	return false;
}

dg_NAMESPACE_END

#define new dg_NEW

#endif /* !debug_LeakCheckerAllocator_h */
