package yukihane.inqubus.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import yukihane.inqubus.cookie.Cookie;
import saccubus.worker.profile.LoginProfile;
import yukihane.inqubus.config.Config.CookieBrowser;

/**
 * コンフィグに設定された値を基にしたLoginProfile実装.
 * @author yuki
 */
public class ConfigLoginProfile implements LoginProfile {

    private final boolean login;
    private final String mail;
    private final String password;
    private final Map<String, String> cookies;

    public ConfigLoginProfile() {
        final Config p = Config.INSTANCE;
        this.login = p.getNeedsLogin();
        this.mail = p.getId();
        this.password = p.getPassword();

        final CookieBrowser cookieBrowser = p.getCookieBrowser();
        final String cookieDir = p.getCookieDir();
        final Cookie cookie = Cookie.create(cookieBrowser.toBrowserType(), cookieDir);
        this.cookies = new HashMap<>(cookie.get());
    }

    @Override
    public boolean needsLogin() {
        return this.login;
    }

    @Override
    public String getMail() {
        return this.mail;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, String> getCookies() {
        return new HashMap<>(this.cookies);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
