package yukihane.inqubus.config;

import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.profile.GeneralProfile;

/**
 * コンフィグに設定された値を基にしたGeneralProfilee実装.
 * @author yuki
 */
public class ConfigGeneralProfile implements GeneralProfile {

    private final String replaceFrom;
    private final String replaceTo;

    public ConfigGeneralProfile() {
        final Config p = Config.INSTANCE;
        this.replaceFrom = p.getReplaceFrom();
        this.replaceTo = p.getReplaceTo();
    }

    @Override
    public String getReplaceFrom() {
        return this.replaceFrom;
    }

    @Override
    public String getReplaceTo() {
        return this.replaceTo;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
